/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractExporterNature;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterFilter;

public class JRXlsAbstractExporterNature
extends AbstractExporterNature {
    protected boolean isIgnoreGraphics;
    protected boolean isIgnorePageMargins;

    protected JRXlsAbstractExporterNature(JasperReportsContext jasperReportsContext, ExporterFilter filter, boolean isIgnoreGraphics, boolean isIgnorePageMargins) {
        super(jasperReportsContext, filter);
        this.isIgnoreGraphics = isIgnoreGraphics;
        this.isIgnorePageMargins = isIgnorePageMargins;
    }

    @Override
    public JRPropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }

    @Override
    public boolean isToExport(JRPrintElement element) {
        return !(this.isIgnoreGraphics && !(element instanceof JRPrintText) && !(element instanceof JRPrintFrame) && !(element instanceof JRGenericPrintElement) || this.filter != null && !this.filter.isToExport(element));
    }

    @Override
    public boolean isDeep(JRPrintFrame frame) {
        return true;
    }

    @Override
    public boolean isSpanCells() {
        return true;
    }

    @Override
    public boolean isIgnoreLastRow() {
        return false;
    }

    @Override
    public boolean isHorizontallyMergeEmptyCells() {
        return false;
    }

    @Override
    public boolean isIgnorePageMargins() {
        return this.isIgnorePageMargins;
    }

    @Override
    public boolean isBreakBeforeRow(JRPrintElement element) {
        return element.hasProperties() && JRPropertiesUtil.asBoolean(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.break.before.row"));
    }

    @Override
    public boolean isBreakAfterRow(JRPrintElement element) {
        return element.hasProperties() && JRPropertiesUtil.asBoolean(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.break.after.row"));
    }

    public Boolean getRowAutoFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.auto.fit.row")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.auto.fit.row", false);
        }
        return null;
    }

    public Boolean getIgnoreRowHeight(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.ignore.row.height")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.ignore.row.height", false);
        }
        return null;
    }

    public Boolean getColumnAutoFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.auto.fit.column")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.auto.fit.column", false);
        }
        return null;
    }

    public Boolean getShowGridlines(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.show.gridlines")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.show.gridlines", true);
        }
        return null;
    }

    public Boolean getIgnoreCellBackground(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.ignore.cell.background")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.ignore.cell.background", false);
        }
        return null;
    }

    public Boolean getIgnoreCellBorder(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.ignore.cell.border")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.ignore.cell.border", false);
        }
        return null;
    }

    public Boolean getWhitePageBackground(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.white.page.background")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.white.page.background", false);
        }
        return null;
    }

    public Integer getCustomColumnWidth(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.column.width")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.column.width", 0);
        }
        return null;
    }

    public Float getColumnWidthRatio(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.column.width.ratio")) {
            return Float.valueOf(this.getPropertiesUtil().getFloatProperty(element, "net.sf.jasperreports.export.xls.column.width.ratio", 0.0f));
        }
        return null;
    }

    public List<JRPropertiesUtil.PropertySuffix> getRowLevelSuffixes(JRPrintElement element) {
        if (element.hasProperties()) {
            return JRPropertiesUtil.getProperties(element, "net.sf.jasperreports.export.xls.row.outline.level.");
        }
        return null;
    }

    public String getSheetName(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.name")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.name");
        }
        return null;
    }

    public EdgeEnum getFreezeRowEdge(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.freeze.row.edge")) {
            return EdgeEnum.getByName(this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.freeze.row.edge"));
        }
        return null;
    }

    public EdgeEnum getFreezeColumnEdge(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.freeze.column.edge")) {
            return EdgeEnum.getByName(this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.freeze.column.edge"));
        }
        return null;
    }

    public String getSheetTabColor(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.tab.color")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.tab.color");
        }
        return null;
    }

    public Integer getPageScale(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.page.scale")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.page.scale", 0);
        }
        return null;
    }

    public Integer getFirstPageNumber(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.first.page.number")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.first.page.number", 0);
        }
        return null;
    }

    public JRPropertiesUtil.PropertySuffix[] getDefinedNames(JRPrintElement element) {
        List<JRPropertiesUtil.PropertySuffix> propertySuffixes;
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.defined.names.") && (propertySuffixes = this.propertiesUtil.getProperties("net.sf.jasperreports.export.xls.defined.names.")) != null && !propertySuffixes.isEmpty()) {
            return propertySuffixes.toArray(new JRPropertiesUtil.PropertySuffix[propertySuffixes.size()]);
        }
        return null;
    }

    @Override
    public void setXProperties(CutsInfo xCuts, JRPrintElement element, int row1, int col1, int row2, int col2) {
        Map<String, Object> xCutsProperties = xCuts.getPropertiesMap();
        this.setXProperties(xCutsProperties, element);
        if (!element.hasProperties()) {
            return;
        }
        Cut cut = xCuts.getCut(col1);
        Boolean columnAutoFit = this.getColumnAutoFit(element);
        if (columnAutoFit != null) {
            if (!cut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.column")) {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.column", columnAutoFit);
            } else {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.column", (Boolean)cut.getProperty("net.sf.jasperreports.export.xls.auto.fit.column") != false && columnAutoFit != false);
            }
        }
        Integer columnCustomWidth = this.getCustomColumnWidth(element);
        Integer cutColumnCustomWidth = (Integer)cut.getProperty("net.sf.jasperreports.export.xls.column.width");
        if (columnCustomWidth != null && (cutColumnCustomWidth == null || cutColumnCustomWidth < columnCustomWidth)) {
            cut.setProperty("net.sf.jasperreports.export.xls.column.width", columnCustomWidth);
        }
    }

    @Override
    public void setXProperties(Map<String, Object> xCutsProperties, JRPrintElement element) {
    }

    private void setMargin(Integer marginValue, Cut cut, String marginName) {
        if (!(marginValue == null || cut.hasProperty(marginName) && (Integer)cut.getProperty(marginName) >= marginValue)) {
            cut.setProperty(marginName, Math.max(marginValue, 0));
        }
    }

    private void setHeaderFooter(String headerFooterValue, Cut cut, String headerFooterName) {
        if (headerFooterValue != null && headerFooterValue.trim().length() > 0) {
            cut.setProperty(headerFooterName, headerFooterValue);
        }
    }

    @Override
    public void setYProperties(CutsInfo yCuts, JRPrintElement element, int row1, int col1, int row2, int col2) {
        Integer printPageWidth;
        Integer printPageHeight;
        Float columnWidthRatio;
        int rowFreezeIndex;
        EdgeEnum freezeRowEdge;
        int columnFreezeIndex;
        EdgeEnum freezeColumnEdge;
        Boolean whitePageBackground;
        Boolean ignoreCellBorder;
        Boolean ignoreCellBackground;
        Boolean showGridlines;
        Integer firstPageNumber;
        Integer pageScale;
        String tabColor;
        String sheetName;
        List<JRPropertiesUtil.PropertySuffix> rowLevelSuffixes;
        Map<String, Object> yCutsProperties = yCuts.getPropertiesMap();
        this.setYProperties(yCutsProperties, element);
        if (!element.hasProperties()) {
            return;
        }
        Cut cut = yCuts.getCut(row1);
        Boolean rowAutoFit = this.getRowAutoFit(element);
        if (rowAutoFit != null) {
            if (!cut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row")) {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.row", rowAutoFit);
            } else {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.row", (Boolean)cut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") != false && rowAutoFit != false);
            }
        }
        if ((rowLevelSuffixes = this.getRowLevelSuffixes(element)) != null && !rowLevelSuffixes.isEmpty()) {
            TreeMap<String, Boolean> levelMap = new TreeMap<String, Boolean>();
            for (JRPropertiesUtil.PropertySuffix suffix : rowLevelSuffixes) {
                String level = suffix.getSuffix();
                String marker = suffix.getValue();
                levelMap.put(level, "end".equalsIgnoreCase(marker));
            }
            cut.setProperty("net.sf.jasperreports.export.xls.row.outline.level.", levelMap);
        }
        if ((sheetName = this.getSheetName(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.sheet.name", sheetName);
        }
        if ((tabColor = this.getSheetTabColor(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.sheet.tab.color", tabColor);
        }
        if ((pageScale = this.getPageScale(element)) != null && pageScale > 9 && pageScale < 401) {
            cut.setProperty("net.sf.jasperreports.export.xls.page.scale", pageScale);
        }
        if ((firstPageNumber = this.getFirstPageNumber(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.first.page.number", firstPageNumber);
        }
        if ((showGridlines = this.getShowGridlines(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.show.gridlines", showGridlines);
        }
        if ((ignoreCellBackground = this.getIgnoreCellBackground(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.ignore.cell.background", ignoreCellBackground);
        }
        if ((ignoreCellBorder = this.getIgnoreCellBorder(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.ignore.cell.border", ignoreCellBorder);
        }
        if ((whitePageBackground = this.getWhitePageBackground(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.white.page.background", whitePageBackground);
        }
        int n = (freezeColumnEdge = this.getFreezeColumnEdge(element)) == null ? 0 : (columnFreezeIndex = EdgeEnum.RIGHT.equals(freezeColumnEdge) ? col2 : col1);
        if (columnFreezeIndex > 0) {
            cut.setProperty("net.sf.jasperreports.export.xls.freeze.column.edge", columnFreezeIndex);
        }
        int n2 = (freezeRowEdge = this.getFreezeRowEdge(element)) == null ? 0 : (rowFreezeIndex = EdgeEnum.BOTTOM.equals(freezeRowEdge) ? row2 : row1);
        if (rowFreezeIndex > 0) {
            cut.setProperty("net.sf.jasperreports.export.xls.freeze.row.edge", rowFreezeIndex);
        }
        if ((columnWidthRatio = this.getColumnWidthRatio(element)) != null && columnWidthRatio.floatValue() > 0.0f) {
            cut.setProperty("net.sf.jasperreports.export.xls.column.width.ratio", columnWidthRatio);
        }
        if (!((printPageHeight = this.getPrintPageHeight(element)) == null || printPageHeight <= 0 || cut.hasProperty("net.sf.jasperreports.export.xls.print.page.height") && (Integer)cut.getProperty("net.sf.jasperreports.export.xls.print.page.height") >= printPageHeight)) {
            cut.setProperty("net.sf.jasperreports.export.xls.print.page.height", printPageHeight);
        }
        if (!((printPageWidth = this.getPrintPageWidth(element)) == null || printPageWidth <= 0 || cut.hasProperty("net.sf.jasperreports.export.xls.print.page.width") && (Integer)cut.getProperty("net.sf.jasperreports.export.xls.print.page.width") >= printPageWidth)) {
            cut.setProperty("net.sf.jasperreports.export.xls.print.page.width", printPageWidth);
        }
        this.setMargin(this.getPrintPageTopMargin(element), cut, "net.sf.jasperreports.export.xls.print.page.top.margin");
        this.setMargin(this.getPrintPageLeftMargin(element), cut, "net.sf.jasperreports.export.xls.print.page.left.margin");
        this.setMargin(this.getPrintPageBottomMargin(element), cut, "net.sf.jasperreports.export.xls.print.page.bottom.margin");
        this.setMargin(this.getPrintPageRightMargin(element), cut, "net.sf.jasperreports.export.xls.print.page.right.margin");
        this.setMargin(this.getPrintHeaderMargin(element), cut, "net.sf.jasperreports.export.xls.print.header.margin");
        this.setMargin(this.getPrintFooterMargin(element), cut, "net.sf.jasperreports.export.xls.print.footer.margin");
        this.setHeaderFooter(this.getSheetHeaderLeft(element), cut, "net.sf.jasperreports.export.xls.sheet.header.left");
        this.setHeaderFooter(this.getSheetHeaderCenter(element), cut, "net.sf.jasperreports.export.xls.sheet.header.center");
        this.setHeaderFooter(this.getSheetHeaderRight(element), cut, "net.sf.jasperreports.export.xls.sheet.header.right");
        this.setHeaderFooter(this.getSheetFooterLeft(element), cut, "net.sf.jasperreports.export.xls.sheet.footer.left");
        this.setHeaderFooter(this.getSheetFooterCenter(element), cut, "net.sf.jasperreports.export.xls.sheet.footer.center");
        this.setHeaderFooter(this.getSheetFooterRight(element), cut, "net.sf.jasperreports.export.xls.sheet.footer.right");
    }

    @Override
    public void setYProperties(Map<String, Object> yCutsProperties, JRPrintElement element) {
    }

    public Integer getPrintPageTopMargin(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.page.top.margin")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.page.top.margin", 0);
        }
        return null;
    }

    public Integer getPrintPageLeftMargin(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.page.left.margin")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.page.left.margin", 0);
        }
        return null;
    }

    public Integer getPrintPageBottomMargin(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.page.bottom.margin")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.page.bottom.margin", 0);
        }
        return null;
    }

    public Integer getPrintPageRightMargin(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.page.right.margin")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.page.right.margin", 0);
        }
        return null;
    }

    public Integer getPrintPageHeight(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.page.height")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.page.height");
        }
        return null;
    }

    public Integer getPrintPageWidth(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.page.width")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.page.width");
        }
        return null;
    }

    public Integer getPrintHeaderMargin(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.header.margin")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.header.margin", 0);
        }
        return null;
    }

    public Integer getPrintFooterMargin(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.print.footer.margin")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.print.footer.margin", 0);
        }
        return null;
    }

    public String getSheetHeaderLeft(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.header.left")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.header.left");
        }
        return null;
    }

    public String getSheetHeaderCenter(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.header.center")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.header.center");
        }
        return null;
    }

    public String getSheetHeaderRight(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.header.right")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.header.right");
        }
        return null;
    }

    public String getSheetFooterLeft(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.footer.left")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.footer.left");
        }
        return null;
    }

    public String getSheetFooterCenter(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.footer.center")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.footer.center");
        }
        return null;
    }

    public String getSheetFooterRight(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.footer.right")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.footer.right");
        }
        return null;
    }
}

