/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.checker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.checker.IStaticCheckerHandler;
import org.codehaus.groovy.eclipse.dsl.checker.ResourceTypeChecker;
import org.codehaus.groovy.eclipse.dsl.checker.SysoutStaticCheckerHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;

public class StaticCheckerApplication
implements IApplication {
    private String projectName;
    private char[][] inclusionFilters;
    private char[][] exclusionFilters;
    private boolean assertionsOnly;
    private String[] extraDslds;
    private IFile[] extraDsldFiles;
    private String projectFolderPath;
    Display display;
    private String resultFile;

    public Object start(IApplicationContext context) throws Exception {
        this.processCommandLine((String[])context.getArguments().get("application.args"));
        try {
            this.display = this.createDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        CheckerWorkbenchAdvisor advisor = new CheckerWorkbenchAdvisor();
        return PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)advisor);
    }

    public PrintStream createOutStream(String fileName) throws FileNotFoundException {
        return new PrintStream(new File(fileName));
    }

    public void stop() {
        this.removeExtraDslds();
    }

    private void addExtraDslds() {
        if (this.extraDslds != null) {
            this.extraDsldFiles = new IFile[this.extraDslds.length];
            int i = 0;
            while (i < this.extraDslds.length) {
                File file = new File(this.extraDslds[i]);
                if (file.exists()) {
                    IFile linkedFile = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName).getFile(file.getName());
                    if (linkedFile.exists() && linkedFile.isLinked()) {
                        try {
                            linkedFile.delete(true, null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!linkedFile.exists()) {
                        try {
                            System.out.println("Adding " + String.valueOf(file.toURI()));
                            linkedFile.createLink(file.toURI(), 0, null);
                            this.extraDsldFiles[i] = linkedFile;
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.err.println("Warning: DSLD file " + this.extraDslds[i] + " doesn't exist.  Ignoring.");
                }
                ++i;
            }
        }
    }

    private void createProject() throws CoreException {
        if (this.projectFolderPath == null) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        if (project.exists()) {
            if (project.getLocation().toOSString().equals(this.projectFolderPath)) {
                return;
            }
            project.delete(9, null);
        }
        IPath dotProjectPath = new Path(this.projectFolderPath).append(".project");
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(dotProjectPath);
        description.setName(this.projectName);
        project.create(description, null);
    }

    private void processCommandLine(String[] args) {
        if (args.length < 1) {
            this.printUsage(true);
            Workbench.getInstance().close();
            return;
        }
        boolean doHelp = false;
        String excludes = null;
        String includes = null;
        this.projectName = args[args.length - 1];
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                doHelp = true;
                break;
            }
            if ("--assertions_only".equals(arg)) {
                this.assertionsOnly = true;
            } else if ("--excludes".equals(arg)) {
                if (i == args.length - 1) {
                    System.err.println("Missing --excludes argument");
                    doHelp = true;
                    break;
                }
                excludes = args[++i];
            } else if ("--includes".equals(arg)) {
                if (i == args.length - 1) {
                    System.err.println("Missing --includes argument");
                    doHelp = true;
                    break;
                }
                includes = args[++i];
            } else if ("--extra_dslds".equals(arg)) {
                if (i == args.length - 1) {
                    System.err.println("Missing --extraDslds argument");
                    doHelp = true;
                    break;
                }
                this.extraDslds = args[++i].split("\\|");
            } else if ("--project_path".equals(arg)) {
                if (i == args.length - 1) {
                    System.err.println("Missing --project_path argument");
                    doHelp = true;
                    break;
                }
                this.projectFolderPath = args[++i];
            } else if ("--result_file".equals(arg)) {
                if (i == args.length - 1) {
                    System.err.println("Missing --result_file argument");
                    doHelp = true;
                    break;
                }
                this.resultFile = args[++i];
            }
            ++i;
        }
        this.inclusionFilters = this.convertToCharChar(includes);
        this.exclusionFilters = this.convertToCharChar(excludes);
        if (doHelp) {
            this.printUsage(false);
            Workbench.getInstance().close();
        }
    }

    private char[][] convertToCharChar(String str) {
        if (str == null) {
            return null;
        }
        String[] splits = str.split("\\|");
        char[][] chars = new char[splits.length][];
        int i = 0;
        while (i < splits.length) {
            chars[i] = ("/" + this.projectName + "/" + splits[i]).toCharArray();
            ++i;
        }
        return chars;
    }

    private void printUsage(boolean isInvalid) {
        if (isInvalid) {
            System.out.println("Invalid command line.");
        }
        System.out.println("Usage:");
        System.out.println("eclipse -application org.codehause.groovy.eclipse.staticCheck [--help] [-h] [--extra_dslds <FILES>] [--assertions_only] [--excludes <PATH>] [--includes <PATH>] [--project_path <PATH>] <PROJECT_NAME>");
        System.out.println("where:");
        System.out.println("\t--help OR -h  Print this message and exit.");
        System.out.println("\t--extra_dslds  list of extra dsld files to be included in this check.  Use '|' as a file separator.");
        System.out.println("\t--assertions_only  Don't report unknown types.  Only look for type assertions");
        System.out.println("\t--excludes  Project-relative exclusion filters.");
        System.out.println("\t--includes  Project-relative inclusion filters.");
        System.out.println("\t--project_path  File system path to the project to check (only required if project is not already in workspace).");
        System.out.println("\t--result_file  File to send static checking results to.  If not specified, then results sent to sysout.");
        System.out.println("\t<PROJECT_NAME>  Name of a project to type check.  If not already in workspace, then must also use '--project_path'.");
        System.out.println();
        System.out.println("Ant style filters are allowed.  For example, src/org/codehaus/groovy/**/*.groovy means all files with groovy extensions in the org.codehaus.groovy tree will be ex/included.  Filters can be concentenated using '|'.");
    }

    private void removeExtraDslds() {
        if (this.extraDsldFiles != null) {
            IFile[] iFileArray = this.extraDsldFiles;
            int n = this.extraDsldFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null && file.exists()) {
                    try {
                        System.out.println("\nRemoving " + String.valueOf(file.getLocation().toFile().toURI()));
                        file.delete(true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    class CheckerJob
    extends Job {
        CheckerJob() {
            super("Checker Job");
        }

        protected IStatus run(IProgressMonitor monitor) {
            boolean success;
            block11: {
                try {
                    JavaCore.initializeAfterLoad((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                try {
                    StaticCheckerApplication.this.createProject();
                }
                catch (CoreException e) {
                    System.err.println("Failed to create project " + StaticCheckerApplication.this.projectName + " at location " + StaticCheckerApplication.this.projectFolderPath);
                    e.printStackTrace();
                    return e.getStatus();
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(StaticCheckerApplication.this.projectName);
                try {
                    project.open(null);
                }
                catch (CoreException e) {
                    System.err.println("Failed to open project " + StaticCheckerApplication.this.projectName);
                    e.printStackTrace();
                    return e.getStatus();
                }
                StaticCheckerApplication.this.addExtraDslds();
                GroovyDSLCoreActivator.getDefault().getContextStoreManager().initialize(project, true);
                System.out.println("Performing static type checking on project " + StaticCheckerApplication.this.projectName);
                success = false;
                try {
                    try {
                        SysoutStaticCheckerHandler handler = new SysoutStaticCheckerHandler(StaticCheckerApplication.this.resultFile == null ? System.out : StaticCheckerApplication.this.createOutStream(StaticCheckerApplication.this.resultFile));
                        ResourceTypeChecker checker = new ResourceTypeChecker((IStaticCheckerHandler)handler, StaticCheckerApplication.this.projectName, StaticCheckerApplication.this.inclusionFilters, StaticCheckerApplication.this.exclusionFilters, StaticCheckerApplication.this.assertionsOnly);
                        success = checker.doCheck(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        StaticCheckerApplication.this.removeExtraDslds();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    StaticCheckerApplication.this.removeExtraDslds();
                    throw throwable;
                }
                StaticCheckerApplication.this.removeExtraDslds();
            }
            StaticCheckerApplication.this.display.asyncExec(() -> {
                boolean bl = Workbench.getInstance().close();
            });
            System.exit(success ? 0 : -1);
            return Status.OK_STATUS;
        }
    }

    public class CheckerWorkbenchAdvisor
    extends WorkbenchAdvisor {
        public String getInitialWindowPerspectiveId() {
            return null;
        }

        public void postStartup() {
            CheckerJob checkerJob = new CheckerJob();
            checkerJob.schedule();
        }

        public void postShutdown() {
            super.postShutdown();
        }
    }
}

