/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.AbstractSuggestionOperation;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IBaseGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.eclipse.core.resources.IProject;

public class RemoveSuggestionOperation
extends AbstractSuggestionOperation {
    private List<IBaseGroovySuggestion> selections;

    public RemoveSuggestionOperation(IProject project, List<IBaseGroovySuggestion> selections) {
        super(project, null);
        this.selections = selections;
    }

    @Override
    public ValueStatus run() {
        InferencingSuggestionsManager.ProjectSuggestions suggestions = InferencingSuggestionsManager.getInstance().getSuggestions(this.getProject());
        if (suggestions != null) {
            for (IBaseGroovySuggestion obj : this.selections) {
                if (obj instanceof GroovySuggestionDeclaringType) {
                    suggestions.removeDeclaringType((GroovySuggestionDeclaringType)obj);
                    continue;
                }
                if (!(obj instanceof IGroovySuggestion)) continue;
                IGroovySuggestion suggestion = (IGroovySuggestion)obj;
                GroovySuggestionDeclaringType declaringType = suggestion.getDeclaringType();
                declaringType.removeSuggestion(suggestion);
                if (!declaringType.getSuggestions().isEmpty()) continue;
                suggestions.removeDeclaringType(declaringType);
            }
        }
        return ValueStatus.getValidStatus(null);
    }
}

