/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionsContributionGroup;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionsPointCut;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.SuggestionsReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;

public class SuggestionsLoader {
    private IFile file;

    public SuggestionsLoader(IFile file) {
        this.file = file;
    }

    public boolean loadExistingSuggestions() {
        if (this.file != null && this.file.isAccessible()) {
            IProject project = this.file.getProject();
            if (InferencingSuggestionsManager.getInstance().isValidProject(project)) {
                IPath path = this.file.getLocation();
                String absoluteFileName = path != null ? path.toString() : null;
                SuggestionsReader reader = new SuggestionsReader(this.file.getProject(), absoluteFileName);
                reader.read();
                this.addSuggestionsContributionGroup();
                return true;
            }
        }
        return false;
    }

    public void addSuggestionsContributionGroup() {
        DSLDStore store = GroovyDSLCoreActivator.getDefault().getContextStoreManager().getDSLDStore(this.file.getProject());
        store.purgeIdentifier((IStorage)this.file);
        store.addContributionGroup(new SuggestionsPointCut(this.file), new SuggestionsContributionGroup(this.file));
    }
}

