/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyMethodSuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyPropertySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IBaseGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.OperationManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage.ISuggestionLabel;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage.ITreeViewerColumn;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage.SuggestionLabelFactory;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage.SuggestionsViewer;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IProjectUIControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ISelectionHandler;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ProjectDropDownControl;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class GroovySuggestionsTable {
    private static final String DEACTIVATE_REMOVE_EDIT_OR_ADD_A_TYPE_SUGGESTION = "Deactivate, remove, edit, or add a type suggestion:";
    private Map<ButtonTypes, Button> selectionButtons;
    private List<IProject> projects;
    private IProjectUIControl selector;
    private SuggestionsViewer viewer;

    public GroovySuggestionsTable(List<IProject> projects) {
        this.projects = projects != null ? projects : new ArrayList();
    }

    public Composite createTable(Composite parent) {
        Composite subparent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(subparent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createProjectArea(subparent);
        return this.createViewerArea(subparent);
    }

    protected void createProjectArea(Composite parent) {
        Composite subparent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(subparent);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)parent);
        ISelectionHandler handler = project -> this.setViewerInput(project);
        this.selector = ProjectDropDownControl.getProjectSelectionControl(this.projects, parent.getShell(), subparent, handler);
        if (this.selector != null) {
            this.selector.createControls();
            IProject previouslyModifiedProject = InferencingSuggestionsManager.getInstance().getlastModifiedProject();
            if (previouslyModifiedProject != null) {
                this.selector.setProject(previouslyModifiedProject);
            }
        }
    }

    protected String getViewerLabel() {
        return DEACTIVATE_REMOVE_EDIT_OR_ADD_A_TYPE_SUGGESTION;
    }

    public IProject getSelectedProject() {
        if (this.selector == null) {
            return null;
        }
        return this.selector.getProject();
    }

    protected Composite createViewerArea(Composite parent) {
        String label = this.getViewerLabel();
        if (label != null && label.length() > 0) {
            Label viewerLabel = new Label(parent, 8);
            viewerLabel.setText(label);
            GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)viewerLabel);
        }
        Composite subparent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(subparent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createTableViewer(subparent);
        this.createOperationButtonArea(subparent);
        return subparent;
    }

    protected void collapseAll() {
        this.viewer.getTreeViewer().collapseAll();
    }

    protected void expandAll() {
        this.viewer.getTreeViewer().expandAll();
    }

    protected void uncheckAll() {
        this.setCheckStateAll(false);
    }

    protected void checkAll() {
        this.setCheckStateAll(true);
    }

    protected void setCheckStateAll(boolean checkState) {
        IProject project = this.getSelectedProject();
        InferencingSuggestionsManager.ProjectSuggestions suggestions = InferencingSuggestionsManager.getInstance().getSuggestions(project);
        if (suggestions != null) {
            Collection<GroovySuggestionDeclaringType> declaringTypes = suggestions.getDeclaringTypes();
            for (GroovySuggestionDeclaringType declaringType : declaringTypes) {
                this.setActiveState(declaringType, checkState);
                this.refresh();
                this.setCheckState(declaringType);
            }
        }
    }

    protected ITreeViewerColumn[] getColumns() {
        return ColumnTypes.values();
    }

    protected void createTableViewer(Composite parent) {
        this.viewer = new SuggestionsViewer(this.getColumns(), ColumnTypes.SUGGESTIONS);
        this.viewer.createControls(parent);
        ContainerCheckedTreeViewer treeViewer = this.viewer.getTreeViewer();
        treeViewer.addCheckStateListener(event -> {
            Object obj = event.getElement();
            this.setActiveState(obj, event.getChecked());
        });
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                GroovySuggestionsTable.this.setCheckState(event.getElement());
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new ViewerLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new ViewerContentProvider());
        treeViewer.setComparator((ViewerComparator)new SuggestionViewerSorter());
        this.setViewerListeners((TreeViewer)treeViewer);
        this.setViewerInput(this.getSelectedProject());
    }

    protected void setActiveState(Object viewerElement, boolean checkState) {
        if (viewerElement instanceof GroovySuggestionDeclaringType) {
            GroovySuggestionDeclaringType declaringType = (GroovySuggestionDeclaringType)viewerElement;
            List<IGroovySuggestion> suggestions = declaringType.getSuggestions();
            for (IGroovySuggestion suggestion : suggestions) {
                suggestion.changeActiveState(checkState);
            }
        } else if (viewerElement instanceof IGroovySuggestion) {
            IGroovySuggestion suggestion = (IGroovySuggestion)viewerElement;
            suggestion.changeActiveState(checkState);
        }
    }

    protected void setCheckState(Object viewerElement) {
        if (viewerElement instanceof GroovySuggestionDeclaringType) {
            GroovySuggestionDeclaringType declaringType = (GroovySuggestionDeclaringType)viewerElement;
            List<IGroovySuggestion> suggestions = declaringType.getSuggestions();
            for (IGroovySuggestion suggestion : suggestions) {
                boolean isSuggestionActive = suggestion.isActive();
                this.viewer.getTreeViewer().setChecked((Object)suggestion, isSuggestionActive);
            }
        } else if (viewerElement instanceof IGroovySuggestion) {
            IGroovySuggestion suggestion = (IGroovySuggestion)viewerElement;
            this.viewer.getTreeViewer().setChecked((Object)suggestion, suggestion.isActive());
        }
    }

    protected void setViewerListeners(TreeViewer tree) {
        tree.addSelectionChangedListener(event -> {
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                this.handleSelectionButtonEnablement(selection.toList());
            }
        });
    }

    protected void handleSelectionButtonEnablement(List<Object> selectedObjects) {
        if (this.projects == null || this.projects.isEmpty()) {
            this.selectionButtons.get((Object)ButtonTypes.ADD).setEnabled(false);
            this.selectionButtons.get((Object)ButtonTypes.EDIT).setEnabled(false);
            this.selectionButtons.get((Object)ButtonTypes.REMOVE).setEnabled(false);
        } else if (selectedObjects == null || selectedObjects.isEmpty()) {
            this.selectionButtons.get((Object)ButtonTypes.ADD).setEnabled(true);
            this.selectionButtons.get((Object)ButtonTypes.EDIT).setEnabled(false);
            this.selectionButtons.get((Object)ButtonTypes.REMOVE).setEnabled(false);
        } else if (selectedObjects.size() == 1) {
            Object selectedObj = selectedObjects.get(0);
            if (selectedObj instanceof GroovySuggestionDeclaringType) {
                this.selectionButtons.get((Object)ButtonTypes.ADD).setEnabled(true);
                this.selectionButtons.get((Object)ButtonTypes.EDIT).setEnabled(false);
                this.selectionButtons.get((Object)ButtonTypes.REMOVE).setEnabled(true);
            } else if (selectedObj instanceof IGroovySuggestion) {
                this.selectionButtons.get((Object)ButtonTypes.ADD).setEnabled(true);
                this.selectionButtons.get((Object)ButtonTypes.EDIT).setEnabled(true);
                this.selectionButtons.get((Object)ButtonTypes.REMOVE).setEnabled(true);
            }
        } else {
            this.selectionButtons.get((Object)ButtonTypes.ADD).setEnabled(false);
            this.selectionButtons.get((Object)ButtonTypes.EDIT).setEnabled(false);
            this.selectionButtons.get((Object)ButtonTypes.REMOVE).setEnabled(true);
        }
    }

    protected void editSuggestion() {
        Object selectedObj;
        if (this.getSelections().size() > 1) {
            return;
        }
        if (this.getSelections().size() == 1 && (selectedObj = this.getSelections().get(0)) instanceof IBaseGroovySuggestion) {
            IBaseGroovySuggestion existingSuggestion = (IBaseGroovySuggestion)selectedObj;
            IGroovySuggestion editedSuggestion = new OperationManager().editGroovySuggestion(this.getSelectedProject(), existingSuggestion, this.getShell());
            if (editedSuggestion != null) {
                this.refresh();
                this.setCheckState(editedSuggestion);
            }
        }
    }

    protected Shell getShell() {
        return this.viewer != null ? this.viewer.getTreeViewer().getTree().getShell() : null;
    }

    protected void addSuggestion() {
        Object selectedObj = this.getSelections().size() == 1 ? this.getSelections().get(0) : null;
        IBaseGroovySuggestion contextSuggestion = selectedObj instanceof IBaseGroovySuggestion ? (IBaseGroovySuggestion)selectedObj : null;
        IGroovySuggestion suggestion = new OperationManager().addGroovySuggestion(this.getSelectedProject(), contextSuggestion, this.getShell());
        if (suggestion != null) {
            this.refresh();
            this.setCheckState(suggestion);
        }
    }

    protected void handleButtonSelection(ButtonTypes button) {
        if (button != null) {
            switch (button) {
                case ADD: {
                    this.addSuggestion();
                    break;
                }
                case EDIT: {
                    this.editSuggestion();
                    break;
                }
                case COLLAPSE_ALL: {
                    this.collapseAll();
                    break;
                }
                case DESELECT_ALL: {
                    this.uncheckAll();
                    break;
                }
                case REMOVE: {
                    this.handleRemove();
                    break;
                }
                case SELECT_ALL: {
                    this.checkAll();
                    break;
                }
                case EXPAND_ALL: {
                    this.expandAll();
                }
            }
        }
    }

    protected void handleRemove() {
        List<Object> selections = this.getSelections();
        ArrayList<IBaseGroovySuggestion> suggestionsToRemove = new ArrayList<IBaseGroovySuggestion>(selections.size());
        for (Object selection : selections) {
            if (!(selection instanceof IBaseGroovySuggestion)) continue;
            suggestionsToRemove.add((IBaseGroovySuggestion)selection);
        }
        new OperationManager().removeGroovySuggestion(this.getSelectedProject(), suggestionsToRemove);
        this.refresh();
    }

    protected void setViewerInput(IProject project) {
        if (this.isViewerDisposed() || project == null) {
            return;
        }
        InferencingSuggestionsManager.ProjectSuggestions suggestions = InferencingSuggestionsManager.getInstance().getSuggestions(project);
        if (suggestions == null) {
            return;
        }
        Collection<GroovySuggestionDeclaringType> declaringTypes = suggestions.getDeclaringTypes();
        if (declaringTypes == null) {
            return;
        }
        this.viewer.getTreeViewer().setInput(declaringTypes);
        this.refresh();
        for (GroovySuggestionDeclaringType declaringType : declaringTypes) {
            this.setCheckState(declaringType);
        }
    }

    protected void refresh() {
        this.viewer.getTreeViewer().refresh(true);
        this.expandAll();
    }

    protected boolean isViewerDisposed() {
        return this.viewer == null || this.viewer.getTreeViewer() == null || this.viewer.getTreeViewer().getTree().isDisposed();
    }

    protected List<Object> getSelections() {
        if (this.viewer.getTreeViewer().getSelection() instanceof IStructuredSelection) {
            return ((IStructuredSelection)this.viewer.getTreeViewer().getSelection()).toList();
        }
        return Collections.EMPTY_LIST;
    }

    protected static String getDisplayString(Object element) {
        ISuggestionLabel suggestionLabel;
        String text = null;
        if (element instanceof GroovySuggestionDeclaringType) {
            return ((GroovySuggestionDeclaringType)element).getName();
        }
        if (element instanceof IGroovySuggestion && (suggestionLabel = new SuggestionLabelFactory().getSuggestionLabel((IGroovySuggestion)element)) != null) {
            text = suggestionLabel.getLabel();
        }
        return text;
    }

    protected void createOperationButtonArea(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(2, 1).applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        ButtonTypes[] types = ButtonTypes.values();
        this.selectionButtons = new HashMap<ButtonTypes, Button>();
        ButtonTypes[] buttonTypesArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ButtonTypes type = buttonTypesArray[n2];
            Button button = this.createSelectionButton(buttons, type);
            if (button != null) {
                this.selectionButtons.put(type, button);
            }
            ++n2;
        }
        this.handleSelectionButtonEnablement(this.getSelections());
    }

    protected Button createSelectionButton(Composite parent, ButtonTypes type) {
        if (type == null) {
            return null;
        }
        Button button = new Button(parent, 8);
        button.setText(type.getLabel());
        button.setData((Object)type);
        Point minSize = button.computeSize(-1, -1, true);
        int widthHint = 0;
        GridDataFactory.fillDefaults().hint(Math.max(widthHint, minSize.x), -1).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object widgetData;
                super.widgetSelected(e);
                Object item = e.getSource();
                if (item instanceof Button && (widgetData = ((Button)item).getData()) instanceof ButtonTypes) {
                    GroovySuggestionsTable.this.handleButtonSelection((ButtonTypes)((Object)widgetData));
                }
            }
        });
        return button;
    }

    static enum ButtonTypes {
        EDIT("Edit..."),
        ADD("Add..."),
        REMOVE("Remove"),
        SELECT_ALL("Select All"),
        DESELECT_ALL("Deselect All"),
        COLLAPSE_ALL("Collapse All"),
        EXPAND_ALL("Expand All");

        private final String label;

        private ButtonTypes(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    static enum ColumnTypes implements ITreeViewerColumn
    {
        SUGGESTIONS("Suggestions", 60);

        private final String label;
        private final int weight;

        private ColumnTypes(String label, int weight) {
            this.label = label;
            this.weight = weight;
        }

        @Override
        public String getName() {
            return this.label;
        }

        @Override
        public int getWidth() {
            return this.weight;
        }
    }

    public static class SuggestionViewerSorter
    extends TreeViewerSorter {
        @Override
        protected String getCompareString(TreeColumn column, Object rowItem) {
            ColumnTypes type = this.getColumnType(column);
            String text = null;
            if (type != null) {
                switch (type) {
                    case SUGGESTIONS: {
                        text = GroovySuggestionsTable.getDisplayString(rowItem);
                    }
                }
            }
            return text;
        }

        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            Tree tree = ((TreeViewer)viewer).getTree();
            TreeColumn sortColumn = tree.getSortColumn();
            ColumnTypes type = this.getColumnType(sortColumn);
            int sortDirection = 1;
            if (type != null) {
                switch (type) {
                    case SUGGESTIONS: {
                        sortDirection = e1 instanceof GroovyPropertySuggestion ? (e2 instanceof GroovyPropertySuggestion ? super.compare(viewer, e1, e2) : (sortDirection == 128 ? -1 : 1)) : (e1 instanceof GroovyMethodSuggestion ? (e2 instanceof GroovyMethodSuggestion ? super.compare(viewer, e1, e2) : (sortDirection == 128 ? 1 : -1)) : super.compare(viewer, e1, e2));
                        return sortDirection;
                    }
                }
            }
            return super.compare(viewer, e1, e2);
        }

        protected ColumnTypes getColumnType(TreeColumn column) {
            String columnName = column.getText();
            ColumnTypes[] columnTypesArray = ColumnTypes.values();
            int n = columnTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnTypes type = columnTypesArray[n2];
                if (type.getName().equals(columnName)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }

    public static abstract class TreeViewerSorter
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (viewer instanceof TreeViewer) {
                Tree tree = ((TreeViewer)viewer).getTree();
                TreeColumn sortColumn = tree.getSortColumn();
                int sortDirection = tree.getSortDirection();
                if (sortColumn != null) {
                    String compareText1 = this.getCompareString(sortColumn, e1);
                    String compareText2 = this.getCompareString(sortColumn, e2);
                    if (compareText1 != null) {
                        if (compareText2 != null) {
                            return sortDirection == 128 ? compareText1.compareToIgnoreCase(compareText2) : compareText2.compareToIgnoreCase(compareText1);
                        }
                        return sortDirection == 128 ? -1 : 1;
                    }
                    if (compareText2 != null) {
                        return sortDirection == 128 ? 1 : -1;
                    }
                }
            }
            return super.compare(viewer, e1, e2);
        }

        protected abstract String getCompareString(TreeColumn var1, Object var2);
    }

    protected static class ViewerContentProvider
    implements ITreePathContentProvider {
        protected ViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                ArrayList suggestedTypes = new ArrayList();
                Collection topLevel = (Collection)inputElement;
                for (Object possibleTypeSuggestion : topLevel) {
                    if (!(possibleTypeSuggestion instanceof GroovySuggestionDeclaringType)) continue;
                    suggestedTypes.add(possibleTypeSuggestion);
                }
                return suggestedTypes.toArray();
            }
            return null;
        }

        public Object[] getChildren(TreePath path) {
            GroovySuggestionDeclaringType treeElement;
            List<IGroovySuggestion> properties;
            Object lastElement = path.getLastSegment();
            if (lastElement instanceof GroovySuggestionDeclaringType && (properties = (treeElement = (GroovySuggestionDeclaringType)lastElement).getSuggestions()) != null) {
                return properties.toArray();
            }
            return null;
        }

        public TreePath[] getParents(Object element) {
            return new TreePath[0];
        }

        public boolean hasChildren(TreePath path) {
            return this.getChildren(path) != null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object e1, Object e2) {
        }
    }

    protected static class ViewerLabelProvider
    extends ColumnLabelProvider {
        protected ViewerLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            int index = cell.getColumnIndex();
            cell.setText(this.getColumnText(element, index));
            cell.setImage(this.getColumnImage(element, index));
            cell.setFont(this.getFont(element));
        }

        public Image getColumnImage(Object element, int index) {
            return null;
        }

        public Font getFont(Object element) {
            return super.getFont(element);
        }

        public String getColumnText(Object element, int index) {
            ColumnTypes[] values = ColumnTypes.values();
            if (index < values.length) {
                ColumnTypes colType = values[index];
                String text = null;
                switch (colType) {
                    case SUGGESTIONS: {
                        text = GroovySuggestionsTable.getDisplayString(element);
                    }
                }
                return text;
            }
            return null;
        }
    }
}

