/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.codehaus.groovy.eclipse.dsl.pointcuts.BindingSet;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;

public class GroovyDSLDContext {
    public final String[] projectNatures;
    public final String fullPathName;
    public final String simpleFileName;
    public final String packageRootPath;
    public final String packageFolderPath;
    private ResolverCache resolverCache;
    private BindingSet currentBinding;
    private VariableScope currentScope;
    private IJavaProject currentProject;
    private Map<String, String> currentOptions;
    private ClassNode targetType;
    private Set<ClassNode> cachedHierarchy;
    private boolean isStatic;
    private boolean isPrimaryNode;

    public GroovyDSLDContext(GroovyCompilationUnit unit, ModuleNode module, JDTResolver jdtResolver) throws CoreException {
        this(GroovyDSLDContext.getProjectNatures(unit), GroovyDSLDContext.getFullPathToFile(unit), GroovyDSLDContext.getPathToPackage(unit));
        this.resolverCache = new ResolverCache(jdtResolver, module);
        this.currentProject = unit.getJavaProject();
    }

    @Deprecated
    public GroovyDSLDContext(String[] projectNatures, String fullPathName, String packageRootPath) {
        String candidate;
        this.fullPathName = fullPathName;
        this.packageRootPath = packageRootPath;
        if (fullPathName != null) {
            int lastDot = fullPathName.lastIndexOf(47);
            this.simpleFileName = fullPathName.substring(lastDot + 1);
        } else {
            this.simpleFileName = null;
        }
        if (packageRootPath != null && packageRootPath.length() < fullPathName.length()) {
            candidate = fullPathName.substring(packageRootPath.length());
            if (this.simpleFileName != null) {
                int start;
                int indexOf = candidate.lastIndexOf("/" + this.simpleFileName);
                int n = start = candidate.startsWith("/") ? 1 : 0;
                if (indexOf > 0 && candidate.length() > 0) {
                    candidate = candidate.substring(start, indexOf);
                }
            }
        } else {
            candidate = "";
        }
        this.packageFolderPath = candidate;
        this.projectNatures = projectNatures;
    }

    private static String[] getProjectNatures(GroovyCompilationUnit unit) throws CoreException {
        return unit.getJavaProject().getProject().getDescription().getNatureIds();
    }

    private static String getFullPathToFile(GroovyCompilationUnit unit) {
        IResource resource = unit.getResource();
        return resource == null ? null : resource.getFullPath().removeFirstSegments(1).toPortableString();
    }

    private static String getPathToPackage(GroovyCompilationUnit unit) {
        IResource resource = unit.getPackageFragmentRoot().getResource();
        return resource == null ? null : resource.getFullPath().removeFirstSegments(1).toPortableString();
    }

    public void addToBinding(String bindingName, Collection<?> toAdd) {
        this.currentBinding.addToBinding(bindingName, toAdd);
    }

    public BindingSet getCurrentBinding() {
        return this.currentBinding;
    }

    public Map<String, String> getCurrentOptions() {
        if (this.currentOptions == null) {
            this.currentOptions = this.currentProject.getOptions(true);
        }
        return this.currentOptions;
    }

    public IJavaProject getCurrentProject() {
        return this.currentProject;
    }

    public VariableScope getCurrentScope() {
        return this.currentScope;
    }

    public ClassNode getCurrentType() {
        return this.targetType;
    }

    public ResolverCache getResolverCache() {
        return this.resolverCache;
    }

    public boolean isPrimaryNode() {
        return this.isPrimaryNode;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean matchesNature(String natureId) {
        if (natureId == null) {
            return false;
        }
        String[] stringArray = this.projectNatures;
        int n = this.projectNatures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (natureId.equals(nature)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean matchesType(String typeName) {
        return this.matchesType(typeName, this.targetType);
    }

    public boolean matchesType(String typeName, ClassNode toCheck) {
        if (typeName == null || toCheck == null) {
            return true;
        }
        if (typeName.equals(toCheck.getName())) {
            return true;
        }
        if (this.cachedHierarchy == null) {
            LinkedHashSet<ClassNode> superTypes = new LinkedHashSet<ClassNode>();
            VariableScope.createTypeHierarchy((ClassNode)toCheck, superTypes, (boolean)false);
            this.cachedHierarchy = superTypes;
        }
        for (ClassNode node : this.cachedHierarchy) {
            if (!typeName.equals(node.getName())) continue;
            return true;
        }
        return false;
    }

    public void resetBinding() {
        this.setCurrentBinding(new BindingSet());
    }

    public void setCurrentBinding(BindingSet currentBinding) {
        this.currentBinding = currentBinding;
    }

    public void setCurrentScope(VariableScope currentScope) {
        this.currentScope = currentScope;
        this.setPrimaryNode(currentScope.isPrimaryNode());
    }

    public void setPrimaryNode(boolean isPrimaryNode) {
        this.isPrimaryNode = isPrimaryNode;
    }

    public void setStatic(boolean s) {
        this.isStatic = s;
    }

    public void setTargetType(ClassNode targetType) {
        if (this.currentScope.isPrimaryNode() && VariableScope.CLASS_CLASS_NODE.equals((Object)targetType) && targetType.isUsingGenerics()) {
            targetType = targetType.getGenericsTypes()[0].getType();
            this.isStatic = true;
        }
        this.targetType = GroovyUtils.getWrapperTypeIfPrimitive((ClassNode)targetType);
        this.cachedHierarchy = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ContextPattern [fileName=");
        builder.append(this.fullPathName);
        builder.append(", targetType=");
        builder.append(this.targetType);
        builder.append(", currentScope=");
        builder.append(this.currentScope);
        builder.append("]");
        return builder.toString();
    }
}

