/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.search.VariableScope;

public class EnclosingCallDeclaringTypePointcut
extends AbstractPointcut {
    public EnclosingCallDeclaringTypePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        List enclosing = pattern.getCurrentScope().getAllEnclosingMethodCallExpressions();
        if (enclosing == null) {
            return null;
        }
        Function<VariableScope.CallAndType, ClassNode> toResult = VariableScope.CallAndType::getPerceivedDeclaringType;
        Object firstArgument = this.getFirstArgument();
        if (firstArgument == null) {
            return enclosing.stream().map(toResult).collect(Collectors.toList());
        }
        if (firstArgument instanceof Class) {
            firstArgument = ((Class)firstArgument).getName();
        }
        if (firstArgument instanceof String) {
            for (VariableScope.CallAndType callAndType : enclosing) {
                ClassNode declaringType = toResult.apply(callAndType);
                if (!firstArgument.equals(declaringType.getName())) continue;
                return Collections.singletonList(declaringType);
            }
            return null;
        }
        return this.matchOnPointcutArgument((IPointcut)firstArgument, pattern, enclosing.stream().map(toResult).collect(Collectors.toList()));
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String result = this.hasNoArgs();
        if (result == null) {
            return;
        }
        result = this.oneStringOrOnePointcutOrOneClassArg();
        if (result != null) {
            throw new PointcutVerificationException(result, this);
        }
        super.verify();
    }
}

