/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public class EnclosingScriptPointcut
extends AbstractPointcut {
    public EnclosingScriptPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        ClassNode enclosing = pattern.getCurrentScope().getEnclosingTypeDeclaration();
        if (enclosing == null || !GroovyUtils.isScript((ClassNode)enclosing)) {
            return null;
        }
        Set<ClassNode> enclosingCollection = Collections.singleton(enclosing);
        Object firstArgument = this.getFirstArgument();
        if (firstArgument instanceof String) {
            if (enclosing.getName().equals(firstArgument)) {
                return enclosingCollection;
            }
            return null;
        }
        if (firstArgument instanceof Class) {
            if (enclosing.getName().equals(((Class)firstArgument).getName())) {
                return enclosingCollection;
            }
            return null;
        }
        if (firstArgument == null) {
            return enclosingCollection;
        }
        return this.matchOnPointcutArgument((IPointcut)firstArgument, pattern, enclosingCollection);
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String hasOneOrNoArgs = this.hasOneOrNoArgs();
        if (hasOneOrNoArgs != null) {
            throw new PointcutVerificationException(hasOneOrNoArgs, this);
        }
        super.verify();
    }
}

