/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.common;

import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebElement;

public class FindElementsResult {
    private List<WebElement> elements;
    private String locator;
    private LocatorStrategy locatorStrategy;
    private String screenshot;

    public FindElementsResult(List<WebElement> elements, String locator, LocatorStrategy locatorStrategy, String screenshot) {
        this.locatorStrategy = locatorStrategy;
        this.locator = locator;
        this.elements = elements;
        this.screenshot = screenshot;
    }

    public FindElementsResult(WebElement element, String locator, LocatorStrategy locatorStrategy, String screenshot) {
        this(new ArrayList<WebElement>(), locator, locatorStrategy, screenshot);
        if (element != null) {
            this.elements.add(element);
        }
    }

    public static FindElementsResult from(List<WebElement> elements, String locator, LocatorStrategy locatorStrategy, String screenshot) {
        return new FindElementsResult(elements, locator, locatorStrategy, screenshot);
    }

    public static FindElementsResult from(List<WebElement> elements, String locator, LocatorStrategy locatorStrategy) {
        return new FindElementsResult(elements, locator, locatorStrategy, "");
    }

    public static FindElementsResult from(WebElement element, String locator, LocatorStrategy locatorStrategy, String screenshot) {
        return new FindElementsResult(element, locator, locatorStrategy, screenshot);
    }

    public static FindElementsResult from(String locator, LocatorStrategy locatorStrategy, String screenshot) {
        return FindElementsResult.from(Collections.emptyList(), locator, locatorStrategy, screenshot);
    }

    public static FindElementsResult from(String locator, LocatorStrategy locatorStrategy) {
        return FindElementsResult.from(locator, locatorStrategy, "");
    }

    public static FindElementsResult from(LocatorStrategy locatorStrategy) {
        return FindElementsResult.from("", locatorStrategy, "");
    }

    public static FindElementsResult from(List<WebElement> elements, TestObject healedTestObject) {
        MobileTestObject mobileTestObject = (MobileTestObject)healedTestObject;
        LocatorStrategy locatorStrategy = mobileTestObject.getLocatorStrategy();
        String locator = (String)mobileTestObject.getLocatorCollection().get(locatorStrategy);
        return FindElementsResult.from(elements, locator, locatorStrategy);
    }

    public LocatorStrategy getLocatorStrategy() {
        return this.locatorStrategy;
    }

    public void setLocatorStrategy(LocatorStrategy locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }

    public List<WebElement> getElements() {
        return this.elements;
    }

    public void setElements(List<WebElement> elements) {
        this.elements = elements;
    }

    public WebElement getElement() {
        return this.elements != null && this.elements.size() > 0 ? this.elements.get(0) : null;
    }

    public void setElement(WebElement element) {
        if (this.elements == null) {
            this.elements = new ArrayList<WebElement>();
        } else {
            this.elements.clear();
        }
        this.elements.add(element);
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }
}

