/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.exception.WebElementNotFoundException;
import com.kms.katalon.core.mobile.helper.AndroidSystemBarProperties;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.mobile.helper.OSBarProperties;
import com.kms.katalon.core.mobile.helper.ViewportRect;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.JsonUtil;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.HasAndroidDeviceDetails;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;

public final class AndroidHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(AndroidHelper.class);
    private static final List<String> SCROLLABLE_CLASSES = Arrays.asList("androidx.recyclerview.widget.RecyclerView", "android.widget.ScrollView", "android.widget.ListView", "androidx.core.widget.NestedScrollView");

    private AndroidHelper() {
    }

    public static int getStatusBarHeight(AppiumDriver driver) {
        int statusBar = 0;
        try {
            statusBar = AndroidHelper.getStatusBarByProperty(driver);
        }
        catch (WebDriverException webDriverException) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "getSystemBar"));
        }
        if (statusBar == 0) {
            try {
                return AndroidHelper.getStatusBarHeightByCommand(driver);
            }
            catch (WebDriverException webDriverException) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "viewportRect"));
            }
        }
        return statusBar;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebElement scrollToText(TestObject testObject, String text, int timeoutInSeconds) throws WebElementNotFoundException {
        block30: {
            endTime = System.currentTimeMillis() + (long)timeoutInSeconds * 1000L;
            driver = (AndroidDriver)MobileDriverFactory.getDriver();
            originalImplicitWait = driver.manage().timeouts().getImplicitWaitTimeout();
            scrollableElement = null;
            if (testObject != null) {
                try {
                    scrollableElement = MobileCommonHelper.findElement((AppiumDriver)driver, testObject, 0);
                }
                catch (Exception v0) {}
            }
            if (scrollableElement == null) {
                scrollableElement = AndroidHelper.findScrollableElement((AppiumDriver)driver);
            }
            if (scrollableElement == null) {
                throw new WebElementNotFoundException("Scrollable element not found");
            }
            remainingTime = endTime - System.currentTimeMillis();
            if (remainingTime <= 0L) {
                AndroidHelper.logger.logWarning("Timeout.");
                return null;
            }
            targetElement = null;
            try {
                driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
                targetElement = AndroidHelper.findElementContainingText(scrollableElement, text);
                if (targetElement != null) {
                    var19_9 = targetElement;
                    return var19_9;
                }
                ** GOTO lbl-1000
            }
            catch (Exception v1) lbl-1000:
            // 2 sources

            {
                remainingTime = endTime - System.currentTimeMillis();
                if (remainingTime > 0L) break block30;
                AndroidHelper.logger.logWarning("Timeout.");
                return null;
            }
        }
        className = scrollableElement.getAttribute("class");
        scrollBackward = String.format("new UiScrollable(new UiSelector().className(\"%s\")).scrollBackward()", new Object[]{className});
        resourceId = scrollableElement.getAttribute("resourceId");
        if (resourceId != null && !resourceId.equals("null")) {
            scrollBackward = String.format("new UiScrollable(new UiSelector().className(\"%s\").resourceId(\"%s\")).scrollBackward()", new Object[]{className, resourceId});
        }
        previousSource = driver.getPageSource();
        canScroll = true;
        while (canScroll) {
            remainingTime = endTime - System.currentTimeMillis();
            if (remainingTime <= 0L) {
                AndroidHelper.logger.logWarning("Timeout.");
                return null;
            }
            try {
                driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
                driver.findElement(AppiumBy.androidUIAutomator((String)scrollBackward));
                currentSource = driver.getPageSource();
                if (AndroidHelper.arePageSourcesEqual(previousSource, currentSource)) {
                    canScroll = false;
                }
                previousSource = currentSource;
            }
            catch (Exception v2) {
                AndroidHelper.logger.logInfo("Scrolling to top.");
                canScroll = false;
            }
        }
        canScroll = true;
        while (canScroll) {
            remainingTime = endTime - System.currentTimeMillis();
            if (remainingTime <= 0L) {
                AndroidHelper.logger.logWarning("Timeout.");
                throw new WebElementNotFoundException(String.format("Element with text '%s' not found", new Object[]{text}));
            }
            try {
                driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
                targetElement = AndroidHelper.findElementContainingText(scrollableElement, text);
                if (targetElement != null) {
                    return targetElement;
                }
                ** GOTO lbl-1000
            }
            catch (Exception v3) {
                try lbl-1000:
                // 2 sources

                {
                    try {
                        scrollForward = String.format("new UiScrollable(new UiSelector().className(\"%s\")).scrollForward()", new Object[]{className});
                        if (resourceId != null && !resourceId.equals("null")) {
                            scrollForward = String.format("new UiScrollable(new UiSelector().className(\"%s\").resourceId(\"%s\")).scrollForward()", new Object[]{className, resourceId});
                        }
                        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
                        driver.findElement(AppiumBy.androidUIAutomator((String)scrollForward));
                        currentSource = driver.getPageSource();
                        if (AndroidHelper.arePageSourcesEqual(previousSource, currentSource)) {
                            canScroll = false;
                        }
                        previousSource = currentSource;
                    }
                    catch (Exception v4) {
                        AndroidHelper.logger.logInfo("Scrolling ended or failed.");
                        canScroll = false;
                    }
                }
                catch (Throwable var18_18) {
                    throw var18_18;
                    throw new WebElementNotFoundException(String.format("Element with text '%s' not found", new Object[]{text}));
                }
            }
        }
        finally {
            driver.manage().timeouts().implicitlyWait(originalImplicitWait);
        }
    }

    public static WebElement findScrollableElement(AppiumDriver driver) {
        List scrollables = driver.findElements(AppiumBy.androidUIAutomator((String)"new UiSelector().scrollable(true)"));
        for (WebElement el : scrollables) {
            if (!"true".equals(el.getAttribute("enabled")) || !"true".equals(el.getAttribute("scrollable")) || !el.isDisplayed()) continue;
            return el;
        }
        for (String clazz : SCROLLABLE_CLASSES) {
            List candidates = driver.findElements(AppiumBy.className((String)clazz));
            for (WebElement el : candidates) {
                if (!"true".equals(el.getAttribute("enabled"))) continue;
                return el;
            }
        }
        return null;
    }

    public static WebElement findElementContainingText(WebElement scrollableView, String text) {
        List elements = scrollableView.findElements(AppiumBy.xpath((String)(".//*[contains(@text, '" + text + "')]")));
        for (WebElement el : elements) {
            if (!"true".equals(el.getAttribute("enabled")) || !el.isDisplayed()) continue;
            return el;
        }
        return null;
    }

    private static int getStatusBarByProperty(AppiumDriver driver) throws WebDriverException {
        Map bars = ((HasAndroidDeviceDetails)driver).getSystemBars();
        AndroidSystemBarProperties barsProps = (AndroidSystemBarProperties)JsonUtil.fromJson((String)JsonUtil.toJson((Object)bars), AndroidSystemBarProperties.class);
        OSBarProperties statusBar = barsProps.getStatusBar();
        if (statusBar != null && statusBar.getWidth() > 0 && statusBar.getHeight() > 0) {
            return statusBar.getHeight();
        }
        return 0;
    }

    private static int getStatusBarHeightByCommand(AppiumDriver driver) {
        Object res = driver.executeScript("mobile:viewportRect", new Object[0]);
        ViewportRect vp = (ViewportRect)JsonUtil.fromJson((String)res.toString(), ViewportRect.class);
        return vp.top == 0 ? 0 : vp.top;
    }

    private static boolean arePageSourcesEqual(String pageSourceA, String pageSourceB) {
        Diff diff = DiffBuilder.compare((Object)pageSourceA).withTest((Object)pageSourceB).withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndAllAttributes})).ignoreWhitespace().checkForSimilar().build();
        return !diff.hasDifferences();
    }
}

