/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.keyword.internal;

import com.google.common.base.Preconditions;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.IOSWebkitStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.ExistingDriverType;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.AppiumSessionCollector;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.mobile.keyword.internal.MobileDeviceInfo;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.util.CryptoUtil;
import io.appium.java_client.AppiumDriver;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;

public class MobileDriverFactory {
    private static final KeywordLogger logger = KeywordLogger.getInstance(MobileDriverFactory.class);
    private static final String WAIT_FOR_APP_SCRIPT_TRUE = "true;";
    private static final String WAIT_FOR_APP_SCRIPT = "waitForAppScript";
    private static final String NO_RESET = "noReset";
    private static final String FULL_RESET = "fullReset";
    private static final int DEFAULT_APPIUM_NEW_COMMAND_TIMEOUT = 1800;
    public static final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public static final String REMOTE_DRIVER_PROPERTY = "Remote";
    public static final String EXISTING_DRIVER_PROPERTY = "Existing";
    public static final String REMOTE_WEB_DRIVER_URL = "remoteWebDriverUrl";
    public static final String IS_REMOTE_WEB_DRIVER_URL_ENCRYPTED = "isEncrypted";

    public static void cleanup() throws InterruptedException, IOException {
        AppiumDriverManager.cleanup();
    }

    public static MobileDriverType getMobileDriverType() {
        String mobileDriverType = RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform");
        return mobileDriverType != null ? MobileDriverType.valueOf(mobileDriverType) : null;
    }

    public static String getRemoteWebDriverServerUrl() {
        boolean isEncrypted;
        String remoteServerUrl = RunConfiguration.getDriverSystemProperty((String)REMOTE_DRIVER_PROPERTY, (String)REMOTE_WEB_DRIVER_URL);
        Map remoteDriverProperties = RunConfiguration.getDriverSystemProperties((String)REMOTE_DRIVER_PROPERTY);
        if (remoteDriverProperties != null && (isEncrypted = RunConfiguration.getBooleanProperty((String)IS_REMOTE_WEB_DRIVER_URL_ENCRYPTED, (Map)remoteDriverProperties))) {
            try {
                remoteServerUrl = CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)remoteServerUrl));
            }
            catch (IOException | GeneralSecurityException exception) {}
        }
        return remoteServerUrl;
    }

    public static String getRemoteWebDriverType() {
        return RunConfiguration.getDriverSystemProperty((String)REMOTE_DRIVER_PROPERTY, (String)"browserType");
    }

    public static MobileDriverType getRemoteMobileDriver() {
        return MobileDriverType.valueOf(RunConfiguration.getDriverSystemProperty((String)REMOTE_DRIVER_PROPERTY, (String)"remoteMobileDriver"));
    }

    public static Map<String, Object> getRemoteWebDriverPreferences() {
        return RunConfiguration.getDriverPreferencesProperties((String)REMOTE_DRIVER_PROPERTY);
    }

    public static String getDevicePlatform() {
        return MobileDriverFactory.getMobileDriverType().toString();
    }

    public static String getDeviceId() {
        return AppiumDriverManager.getDeviceId((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getRemoteDeviceId() {
        return AppiumDriverManager.getDeviceId((String)REMOTE_DRIVER_PROPERTY);
    }

    public static String getDeviceName() {
        return AppiumDriverManager.getDeviceName((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getRemoteDeviceName() {
        return AppiumDriverManager.getDeviceName((String)REMOTE_DRIVER_PROPERTY);
    }

    public static String getDeviceModel() {
        return AppiumDriverManager.getDeviceModel((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getRemoteDeviceModel() {
        return AppiumDriverManager.getDeviceModel((String)REMOTE_DRIVER_PROPERTY);
    }

    public static String getDeviceManufacturer() {
        return AppiumDriverManager.getDeviceManufacturer((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getRemoteDeviceManufacturer() {
        return AppiumDriverManager.getDeviceManufacturer((String)REMOTE_DRIVER_PROPERTY);
    }

    public static String getDeviceOSVersion() {
        return AppiumDriverManager.getDeviceOSVersion((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getRemoteDeviceOSVersion() {
        return AppiumDriverManager.getDeviceOSVersion((String)REMOTE_DRIVER_PROPERTY);
    }

    public static String getDeviceOS() {
        return AppiumDriverManager.getDeviceOS((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getRemoteDeviceOS() {
        return AppiumDriverManager.getDeviceOS((String)REMOTE_DRIVER_PROPERTY);
    }

    public static AppiumDriver getDriver() throws StepFailedException {
        try {
            AppiumDriver driver = AppiumDriverManager.getDriver();
            return driver;
        }
        catch (StepFailedException e) {
            if (MobileDriverFactory.isUsingExistingDriver()) {
                try {
                    return MobileDriverFactory.startExistingBrowser();
                }
                catch (MobileDriverInitializeException | MalformedURLException throwable) {}
            }
            throw e;
        }
    }

    public static void setDriver(AppiumDriver driver) {
        AppiumDriverManager.setDriver((AppiumDriver)driver);
    }

    public static void closeDriver() {
        try {
            AppiumDriver driver = AppiumDriverManager.getDriver();
            if (driver != null) {
                AppiumSessionCollector.removeSession(driver);
                AppiumDriverManager.closeDriver();
            }
        }
        catch (StepFailedException stepFailedException) {}
    }

    private static DesiredCapabilities convertPropertiesMaptoDesireCapabilities(Map<String, Object> propertyMap, MobileDriverType mobileDriverType) {
        DesiredCapabilities desireCapabilities = new DesiredCapabilities();
        String prefix = AppiumVersionUtil.getInstance().getAppiumDesiredCapabilityPrefix();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            desireCapabilities.setCapability(prefix + property.getKey(), property.getValue());
            if (MobileDriverFactory.isRunFromTestCloudWithSauceLabs(property)) continue;
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_MOBILE_PROPERTY_SETTING, property.getKey(), property.getValue()));
        }
        return desireCapabilities;
    }

    private static boolean isRunFromTestCloudWithSauceLabs(Map.Entry<String, Object> property) {
        return TestCloudPropertyUtil.getInstance().isRunFromTestCloud() && (property.getKey().equals("accessKey") || property.getKey().equals("username"));
    }

    private static DesiredCapabilities createCapabilities(MobileDeviceInfo mobileDeviceInfo, String appId, String driverConnectorId) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        Map driverPreferences = RunConfiguration.getDriverPreferencesProperties((String)driverConnectorId);
        if (driverPreferences.containsKey("browserName")) {
            driverPreferences.remove("browserName");
        }
        String prefix = AppiumVersionUtil.getInstance().getAppiumDesiredCapabilityPrefix();
        if (StringUtils.isNotEmpty((CharSequence)mobileDeviceInfo.getDeviceOS())) {
            capabilities.setCapability(prefix + "platformVersion", mobileDeviceInfo.getDeviceOSVersion());
        }
        capabilities.setCapability(prefix + "deviceName", mobileDeviceInfo.getDeviceName());
        if (mobileDeviceInfo.getDeviceId() != null) {
            capabilities.setCapability(prefix + "udid", mobileDeviceInfo.getDeviceId());
        }
        int finalNewCommandTimeout = RunConfiguration.getAppiumNewCommandTimeout().orElse(1800);
        capabilities.setCapability(prefix + "newCommandTimeout", (Object)finalNewCommandTimeout);
        if (driverPreferences != null && mobileDeviceInfo.getDriverType() == MobileDriverType.IOS_DRIVER) {
            capabilities.setCapability(prefix + "bundleId", appId);
            capabilities.setCapability(prefix + WAIT_FOR_APP_SCRIPT, WAIT_FOR_APP_SCRIPT_TRUE);
            try {
                int xcodeVersion = AppiumDriverManager.getXCodeVersion();
                if (xcodeVersion >= 8) {
                    capabilities.setCapability(prefix + "automationName", "XCUITest");
                    capabilities.setCapability(prefix + "wdaLocalPort", (Object)AppiumDriverManager.getFreePort());
                    if (xcodeVersion < 15) {
                        capabilities.setCapability(prefix + "realDeviceLogger", RunConfiguration.getDeviceConsoleExecutable());
                    }
                }
            }
            catch (ExecutionException executionException) {}
            if (mobileDeviceInfo.getDeviceId() == null) {
                capabilities.setCapability("platformName", MobileDriverFactory.getDeviceOS());
            }
            capabilities.merge((Capabilities)MobileDriverFactory.convertPropertiesMaptoDesireCapabilities(driverPreferences, MobileDriverType.IOS_DRIVER));
        } else if (driverPreferences != null && mobileDeviceInfo.getDriverType() == MobileDriverType.ANDROID_DRIVER) {
            capabilities.setCapability("platformName", Platform.ANDROID);
            if (MobileDriverFactory.isUsingAndroid7OrBigger()) {
                capabilities.setCapability(prefix + "automationName", "uiautomator2");
            }
            capabilities.setCapability(prefix + "autoGrantPermissions", true);
            capabilities.setCapability(prefix + "systemPort", (Object)AppiumDriverManager.nextFreePort((int)8200, (int)8299));
            capabilities.merge((Capabilities)MobileDriverFactory.convertPropertiesMaptoDesireCapabilities(driverPreferences, MobileDriverType.ANDROID_DRIVER));
        }
        return capabilities;
    }

    private static DesiredCapabilities createCapabilities(MobileDriverType osType, String deviceId, String deviceName, String platformVersion, String appFile, boolean uninstallAfterCloseApp) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        Map driverPreferences = RunConfiguration.getDriverPreferencesProperties((String)MOBILE_DRIVER_PROPERTY);
        if (driverPreferences.containsKey("browserName")) {
            driverPreferences.remove("browserName");
        }
        String prefix = AppiumVersionUtil.getInstance().getAppiumDesiredCapabilityPrefix();
        if (StringUtils.isNotEmpty((CharSequence)platformVersion)) {
            capabilities.setCapability(prefix + "platformVersion", platformVersion);
        }
        capabilities.setCapability(prefix + "deviceName", deviceName);
        capabilities.setCapability(prefix + "app", appFile);
        if (deviceId != null) {
            capabilities.setCapability(prefix + "udid", deviceId);
        }
        capabilities.setCapability(prefix + FULL_RESET, uninstallAfterCloseApp);
        capabilities.setCapability(prefix + NO_RESET, !uninstallAfterCloseApp);
        int finalNewCommandTimeout = RunConfiguration.getAppiumNewCommandTimeout().orElse(1800);
        capabilities.setCapability(prefix + "newCommandTimeout", (Object)finalNewCommandTimeout);
        if (driverPreferences != null && osType == MobileDriverType.IOS_DRIVER) {
            capabilities.setCapability(prefix + WAIT_FOR_APP_SCRIPT, WAIT_FOR_APP_SCRIPT_TRUE);
            try {
                int xcodeVersion = AppiumDriverManager.getXCodeVersion();
                if (xcodeVersion >= 8) {
                    capabilities.setCapability(prefix + "automationName", "XCUITest");
                    capabilities.setCapability(prefix + "wdaLocalPort", (Object)AppiumDriverManager.getFreePort());
                    if (xcodeVersion < 15) {
                        capabilities.setCapability(prefix + "realDeviceLogger", RunConfiguration.getDeviceConsoleExecutable());
                    }
                }
            }
            catch (ExecutionException executionException) {}
            if (deviceId == null) {
                capabilities.setCapability(prefix + "platformName", MobileDriverFactory.getDeviceOS());
            }
            capabilities.merge((Capabilities)MobileDriverFactory.convertPropertiesMaptoDesireCapabilities(driverPreferences, MobileDriverType.IOS_DRIVER));
        } else if (driverPreferences != null && osType == MobileDriverType.ANDROID_DRIVER) {
            capabilities.setCapability(prefix + "platformName", Platform.ANDROID);
            if (MobileDriverFactory.isUsingAndroid7OrBigger()) {
                capabilities.setCapability(prefix + "automationName", "uiautomator2");
            }
            capabilities.setCapability(prefix + "autoGrantPermissions", true);
            capabilities.setCapability(prefix + "systemPort", (Object)AppiumDriverManager.getFreePort());
            capabilities.merge((Capabilities)MobileDriverFactory.convertPropertiesMaptoDesireCapabilities(driverPreferences, MobileDriverType.ANDROID_DRIVER));
        }
        return capabilities;
    }

    public static boolean isUsingAndroid7OrBigger() {
        String[] splitParts;
        block5: {
            String osVersion;
            block4: {
                try {
                    osVersion = MobileDriverFactory.getDeviceOSVersion();
                    if (!StringUtils.isEmpty((CharSequence)osVersion)) break block4;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            splitParts = osVersion.split("\\.");
            if (splitParts != null && splitParts.length != 0) break block5;
            return false;
        }
        String osVersionMajor = splitParts[0];
        Number androidVersion = NumberUtils.createNumber((String)osVersionMajor);
        return androidVersion.intValue() >= 7;
    }

    private static boolean isUsingExistingDriver() {
        return MobileDriverFactory.getExistingDriver() != null;
    }

    public static AppiumDriver startMobileDriver(String appId) throws AppiumStartException, IOException, InterruptedException, MobileDriverInitializeException, IOSWebkitStartException {
        AppiumDriver driver;
        if (MobileDriverFactory.isUsingExistingDriver()) {
            return MobileDriverFactory.startExistingBrowser();
        }
        String remoteWebUrl = MobileDriverFactory.getRemoteWebDriverServerUrl();
        if (StringUtils.isNotEmpty((CharSequence)remoteWebUrl)) {
            MobileDeviceInfo remoteMobileDeviceInfo = MobileDeviceInfo.create(MobileDriverFactory.getRemoteMobileDriver(), MobileDriverFactory.getRemoteDeviceId(), MobileDriverFactory.getRemoteDeviceName(), MobileDriverFactory.getRemoteDeviceOS(), MobileDriverFactory.getRemoteDeviceOSVersion());
            driver = AppiumDriverManager.createMobileDriver((IDriverType)remoteMobileDeviceInfo.getDriverType(), (MutableCapabilities)MobileDriverFactory.createCapabilities(remoteMobileDeviceInfo, appId, REMOTE_DRIVER_PROPERTY), (URL)new URL(remoteWebUrl));
        } else {
            MobileDeviceInfo mobileDeviceInfo = MobileDeviceInfo.create(MobileDriverFactory.getMobileDriverType(), MobileDriverFactory.getDeviceId(), MobileDriverFactory.getDeviceName(), MobileDriverFactory.getDeviceOS(), MobileDriverFactory.getDeviceOSVersion());
            driver = AppiumDriverManager.createMobileDriver((IDriverType)mobileDeviceInfo.getDriverType(), (String)mobileDeviceInfo.getDeviceId(), (DesiredCapabilities)MobileDriverFactory.createCapabilities(mobileDeviceInfo, appId, MOBILE_DRIVER_PROPERTY));
        }
        if (driver != null) {
            MobileDriverFactory.saveWebDriverSessionData(driver);
            MobileCommonHelper.setCommonAppiumSessionProperties(driver);
        }
        return driver;
    }

    public static AppiumDriver startMobileDriver(String appFile, boolean uninstallAfterCloseApp) throws AppiumStartException, IOException, InterruptedException, MobileDriverInitializeException, IOSWebkitStartException {
        AppiumDriver driver;
        if (MobileDriverFactory.isUsingExistingDriver()) {
            return MobileDriverFactory.startExistingBrowser();
        }
        String remoteWebUrl = MobileDriverFactory.getRemoteWebDriverServerUrl();
        if (StringUtils.isNotEmpty((CharSequence)remoteWebUrl)) {
            DesiredCapabilities desiredCapabilities = new DesiredCapabilities(MobileDriverFactory.getRemoteWebDriverPreferences());
            if (desiredCapabilities.asMap().containsKey("testCloudOverrideMobileApplication")) {
                desiredCapabilities.setCapability("testCloudOverrideMobileApplication", null);
            }
            driver = MobileDriverFactory.startRemoteMobileDriver(remoteWebUrl, desiredCapabilities, MobileDriverFactory.getRemoteMobileDriver(), appFile);
        } else {
            driver = MobileDriverFactory.startLocalMobileDriver(MobileDriverFactory.getMobileDriverType(), MobileDriverFactory.getDeviceId(), MobileDriverFactory.getDeviceName(), MobileDriverFactory.getDeviceOSVersion(), appFile, uninstallAfterCloseApp);
        }
        if (driver != null) {
            MobileDriverFactory.saveWebDriverSessionData(driver);
            MobileCommonHelper.setCommonAppiumSessionProperties(driver);
        }
        return driver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveWebDriverSessionData(AppiumDriver remoteWebDriver) {
        if (RunConfiguration.getRunningMode() == RunningMode.CONSOLE) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                Socket myClient = new Socket(RunConfiguration.getSessionServerHost(), RunConfiguration.getSessionServerPort());
                try {
                    try (PrintStream output = new PrintStream(myClient.getOutputStream());){
                        output.println(remoteWebDriver.getSessionId());
                        output.println(MobileDriverFactory.getWebDriverServerUrl(remoteWebDriver));
                        output.println(MobileDriverFactory.getMobileDriverType().toString());
                        output.println(RunConfiguration.getLogFolderPath());
                        IDriverType executedDriver = MobileDriverFactory.getExecutedDriver();
                        if (MobileDriverFactory.getRemoteWebDriverServerUrl() != null) {
                            output.println(MobileDriverFactory.getRemoteWebDriverType());
                            output.println(MobileDriverFactory.getDeviceName() + " " + MobileDriverFactory.getDeviceOSVersion());
                        } else {
                            output.println("");
                            if (executedDriver == MobileDriverType.ANDROID_DRIVER) {
                                output.println(MobileDriverFactory.getDeviceManufacturer() + " " + MobileDriverFactory.getDeviceModel() + " " + MobileDriverFactory.getDeviceOSVersion());
                            } else if (executedDriver == MobileDriverType.IOS_DRIVER) {
                                output.println(MobileDriverFactory.getDeviceName() + " " + MobileDriverFactory.getDeviceOSVersion());
                            }
                        }
                        output.flush();
                    }
                    if (myClient == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (myClient == null) throw throwable;
                    myClient.close();
                    throw throwable;
                }
                myClient.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    public static IDriverType getExecutedDriver() {
        ExistingDriverType existingDriver = MobileDriverFactory.getExistingDriver();
        return existingDriver != null ? existingDriver : MobileDriverFactory.getMobileDriverType();
    }

    private static ExistingDriverType getExistingDriver() {
        if (RunConfiguration.getDriverSystemProperties((String)EXISTING_DRIVER_PROPERTY) != null) {
            return new ExistingDriverType("");
        }
        return null;
    }

    private static String getWebDriverServerUrl(AppiumDriver remoteWebDriver) {
        return ((HttpCommandExecutor)remoteWebDriver.getCommandExecutor()).getAddressOfRemoteServer().toString();
    }

    protected static AppiumDriver startExistingBrowser() throws MalformedURLException, MobileDriverInitializeException {
        return AppiumDriverManager.startExisitingMobileDriver((IDriverType)MobileDriverType.fromStringValue(RunConfiguration.getExistingSessionDriverType()), (String)RunConfiguration.getExistingSessionSessionId(), (String)RunConfiguration.getExistingSessionServerUrl());
    }

    public static AppiumDriver startLocalMobileDriver(MobileDriverType osType, String deviceId, String deviceName, String platformVersion, String appFile, boolean uninstallAfterCloseApp) throws MobileDriverInitializeException, IOException, InterruptedException, AppiumStartException {
        Preconditions.checkArgument((osType != null && StringUtils.isNotEmpty((CharSequence)deviceName) ? 1 : 0) != 0, (Object)CoreMobileMessageConstants.KW_MSG_DEVICE_MISSING);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appFile), (Object)CoreMobileMessageConstants.KW_MSG_APP_FILE_MISSING);
        return AppiumDriverManager.createMobileDriver((IDriverType)osType, (String)deviceId, (DesiredCapabilities)MobileDriverFactory.createCapabilities(osType, deviceId, deviceName, platformVersion, appFile, uninstallAfterCloseApp));
    }

    public static AppiumDriver startRemoteMobileDriver(String remoteWebUrl, DesiredCapabilities desiredCapabilities, MobileDriverType driverType, String appFile) throws MalformedURLException, MobileDriverInitializeException {
        if (StringUtils.isNotBlank((CharSequence)appFile)) {
            desiredCapabilities.setCapability("app", appFile);
        }
        return AppiumDriverManager.createMobileDriver((IDriverType)driverType, (MutableCapabilities)desiredCapabilities, (URL)new URL(remoteWebUrl));
    }
}

