/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Scenario;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Match;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.StepDefinitionMatch;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.UndefinedDataTableTypeException;
import io.cucumber.stepexpression.Argument;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PickleStepDefinitionMatch
extends Match
implements StepDefinitionMatch {
    private final StepDefinition stepDefinition;
    private final transient String featurePath;
    private final transient PickleStep step;

    public PickleStepDefinitionMatch(List<Argument> arguments, StepDefinition stepDefinition, String featurePath, PickleStep step) {
        super(arguments, stepDefinition.getLocation(false));
        this.stepDefinition = stepDefinition;
        this.featurePath = featurePath;
        this.step = step;
    }

    @Override
    public void runStep(String language, Scenario scenario) throws Throwable {
        int argumentCount = this.getArguments().size();
        Integer parameterCount = this.stepDefinition.getParameterCount();
        if (parameterCount != null && argumentCount != parameterCount) {
            throw this.arityMismatch(parameterCount);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            for (Argument argument : this.getArguments()) {
                result.add(argument.getValue());
            }
        }
        catch (UndefinedDataTableTypeException e) {
            throw this.registerTypeInConfiguration((Exception)((Object)e));
        }
        catch (CucumberExpressionException e) {
            throw this.couldNotConvertArguments((Exception)((Object)e));
        }
        catch (CucumberDataTableException e) {
            throw this.couldNotConvertArguments((Exception)((Object)e));
        }
        try {
            this.stepDefinition.execute(language, result.toArray(new Object[result.size()]));
        }
        catch (CucumberException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.removeFrameworkFramesAndAppendStepLocation(t, this.getStepLocation());
        }
    }

    private CucumberException registerTypeInConfiguration(Exception e) {
        return new CucumberException(String.format("Could not convert arguments for step [%s] defined at '%s'.\nIt appears you did not register a data table type. The details are in the stacktrace below.", this.stepDefinition.getPattern(), this.stepDefinition.getLocation(true)), e);
    }

    private CucumberException couldNotConvertArguments(Exception e) {
        return new CucumberException(String.format("Could not convert arguments for step [%s] defined at '%s'.\nThe details are in the stacktrace below.", this.stepDefinition.getPattern(), this.stepDefinition.getLocation(true)), e);
    }

    @Override
    public void dryRunStep(String language, Scenario scenario) throws Throwable {
    }

    private CucumberException arityMismatch(int parameterCount) {
        List<String> arguments = this.createArgumentsForErrorMessage();
        return new CucumberException(String.format("Step [%s] is defined with %s parameters at '%s'.\nHowever, the gherkin step has %s arguments%sStep text: %s", this.stepDefinition.getPattern(), parameterCount, this.stepDefinition.getLocation(true), arguments.size(), this.formatArguments(arguments), this.step.getText()));
    }

    private String formatArguments(List<String> arguments) {
        if (arguments.isEmpty()) {
            return ".\n";
        }
        StringBuilder formatted = new StringBuilder(":\n");
        for (String argument : arguments) {
            formatted.append(" * ").append(argument).append("\n");
        }
        return formatted.toString();
    }

    private List<String> createArgumentsForErrorMessage() {
        ArrayList<String> arguments = new ArrayList<String>(this.getArguments().size());
        for (Argument argument : this.getArguments()) {
            arguments.add(argument.toString());
        }
        return arguments;
    }

    protected Throwable removeFrameworkFramesAndAppendStepLocation(Throwable error, StackTraceElement stepLocation) {
        int newStackTraceLength;
        StackTraceElement[] stackTraceElements = error.getStackTrace();
        if (stackTraceElements.length == 0 || stepLocation == null) {
            return error;
        }
        for (newStackTraceLength = 1; newStackTraceLength < stackTraceElements.length && !this.stepDefinition.isDefinedAt(stackTraceElements[newStackTraceLength - 1]); ++newStackTraceLength) {
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[newStackTraceLength + 1];
        System.arraycopy(stackTraceElements, 0, newStackTrace, 0, newStackTraceLength);
        newStackTrace[newStackTraceLength] = stepLocation;
        error.setStackTrace(newStackTrace);
        return error;
    }

    private Locale localeFor(String language) {
        String[] languageAndCountry = language.split("-");
        if (languageAndCountry.length == 1) {
            return new Locale(language);
        }
        return new Locale(languageAndCountry[0], languageAndCountry[1]);
    }

    public String getPattern() {
        return this.stepDefinition.getPattern();
    }

    public StackTraceElement getStepLocation() {
        return new StackTraceElement("\u273d", this.step.getText(), this.featurePath, PickleStepDefinitionMatch.getStepLine(this.step));
    }

    public Match getMatch() {
        return this;
    }

    StepDefinition getStepDefinition() {
        return this.stepDefinition;
    }

    @Override
    public String getCodeLocation() {
        return this.stepDefinition.getLocation(false);
    }

    public static int getStepLine(PickleStep step) {
        return ((PickleLocation)step.getLocations().get(step.getLocations().size() - 1)).getLine();
    }
}

