/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.ai.openai.models.AudioTranscriptionFormat;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;

public final class AudioTranscriptionValidator {
    private static final ClientLogger LOGGER = new ClientLogger(AudioTranscriptionValidator.class);

    public static void validateAudioResponseFormatForTranscription(AudioTranscriptionOptions audioTranscriptionOptions) {
        ArrayList<AudioTranscriptionFormat> acceptedFormats = new ArrayList<AudioTranscriptionFormat>();
        acceptedFormats.add(AudioTranscriptionFormat.JSON);
        acceptedFormats.add(AudioTranscriptionFormat.VERBOSE_JSON);
        AudioTranscriptionFormat responseFormat = audioTranscriptionOptions.getResponseFormat();
        if (!acceptedFormats.contains((Object)responseFormat)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("This operation does not support the requested audio format: " + (Object)((Object)responseFormat) + ", supported formats: JSON, VERBOSE_JSON."));
        }
    }

    public static void validateAudioResponseFormatForTranscriptionText(AudioTranscriptionOptions audioTranscriptionOptions) {
        ArrayList<AudioTranscriptionFormat> acceptedFormats = new ArrayList<AudioTranscriptionFormat>();
        acceptedFormats.add(AudioTranscriptionFormat.TEXT);
        acceptedFormats.add(AudioTranscriptionFormat.VTT);
        acceptedFormats.add(AudioTranscriptionFormat.SRT);
        AudioTranscriptionFormat responseFormat = audioTranscriptionOptions.getResponseFormat();
        if (!acceptedFormats.contains((Object)responseFormat)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("This operation does not support the requested audio format: " + (Object)((Object)responseFormat) + ", supported formats: TEXT, VTT, SRT."));
        }
    }
}

