/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.custom.factory.CustomKeywordPluginFactory;
import com.kms.katalon.custom.improvement.factory.NewPluginTestListenerFactory;
import com.kms.katalon.custom.improvement.parser.ImprovedCustomKeywordParser;
import com.kms.katalon.custom.keyword.CustomKeywordPlugin;
import com.kms.katalon.custom.keyword.KeywordsManifest;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;

public class ImprovedKeywordControllerDelegate {
    public static void parseAllCustomKeywords(ProjectEntity project, IProgressMonitor monitor) throws Exception {
        ImprovedKeywordControllerDelegate.parseAllCustomKeywords(project, monitor, true);
    }

    public static void parseAllCustomKeywords(ProjectEntity project, IProgressMonitor monitor, boolean isReload) throws Exception {
        try {
            if (monitor != null) {
                monitor.beginTask("Parsing custom keywords...", 1);
            }
            ImprovedKeywordControllerDelegate.parseKeywordPluginsManifest();
            NewPluginTestListenerFactory.getInstance().clear();
            List pluginFiles = CustomKeywordPluginFactory.getInstance().getStoredPluginFiles();
            ImprovedCustomKeywordParser.getInstance().parseCustomKeywords(project, pluginFiles, isReload);
            if (isReload) {
                ImprovedKeywordControllerDelegate.refreshCustomKeywordLibFile(project, monitor);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void parsePluginCustomKeywords(ProjectEntity project, IProgressMonitor monitor) throws Exception {
        try {
            if (monitor != null) {
                monitor.beginTask("Parsing custom keywords...", 1);
            }
            ImprovedKeywordControllerDelegate.parseKeywordPluginsManifest();
            NewPluginTestListenerFactory.getInstance().clear();
            List pluginFiles = CustomKeywordPluginFactory.getInstance().getStoredPluginFiles();
            ImprovedCustomKeywordParser.getInstance().parseCustomPlugins(project, pluginFiles);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void parseKeywordPluginsManifest() throws IOException {
        List plugins = CustomKeywordPluginFactory.getInstance().getPlugins();
        for (CustomKeywordPlugin plugin : plugins) {
            JarFile jar = new JarFile(plugin.getPluginFile());
            try {
                ZipEntry jsonEntry = jar.getEntry("katalon-plugin.json");
                if (jsonEntry != null) {
                    InputStreamReader reader = new InputStreamReader(jar.getInputStream(jsonEntry));
                    KeywordsManifest manifest = (KeywordsManifest)JsonUtil.fromJson((Reader)reader, KeywordsManifest.class);
                    plugin.setKeywordsManifest(manifest);
                }
            }
            catch (Exception e) {
                LogUtil.printAndLogError((Throwable)e);
                jar.close();
                continue;
            }
            catch (NoClassDefFoundError e) {
                try {
                    LogUtil.printAndLogError((Throwable)e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    jar.close();
                }
            }
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseCustomKeywordFile(IFile file, ProjectEntity project) throws Exception {
        ProjectEntity projectEntity = project;
        synchronized (projectEntity) {
            ProjectController.getInstance().updateProjectClassLoader(project);
            ImprovedCustomKeywordParser.getInstance().parseCustomKeywordFile(file.getLocation().toFile(), project);
            ImprovedKeywordControllerDelegate.refreshCustomKeywordLibFile(project, null);
        }
    }

    public static void removeKeywordClassesByFile(IFile file, ProjectEntity project) throws Exception {
        ImprovedCustomKeywordParser.getInstance().removeKeywordClassesByKeywordFile(file.getLocation().toFile(), project);
        ImprovedKeywordControllerDelegate.refreshCustomKeywordLibFile(project, null);
    }

    public static void parseCustomKeywordInPackage(IPackageFragment packageFragment, ProjectEntity project) throws Exception {
        List compilationUnits = GroovyUtil.getAllGroovyClasses((IPackageFragment)packageFragment);
        List files = compilationUnits.stream().map(cu -> cu.getResource().getLocation().toFile()).collect(Collectors.toList());
        ImprovedCustomKeywordParser.getInstance().parseCustomKeywordFiles(files, project);
        ImprovedKeywordControllerDelegate.refreshCustomKeywordLibFile(project, null);
    }

    private static void refreshCustomKeywordLibFile(ProjectEntity project, IProgressMonitor monitor) throws Exception {
        GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project).refreshLocal(1, monitor);
    }
}

