/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.ImprovedKeywordControllerDelegate;
import com.kms.katalon.custom.factory.BuiltInMethodNodeFactory;
import com.kms.katalon.custom.factory.CustomMethodNodeFactory;
import com.kms.katalon.custom.improvement.parser.ImprovedCustomKeywordParser;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.parser.CustomKeywordParser;
import com.kms.katalon.custom.util.BuiltinPluginUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;

public class KeywordController
extends EntityController {
    private static final String TESTNG_BUILTIN_KEYWORDS_CLASS_NAME = "TestNGBuiltinKeywords";
    public static final String CUSTOM_KEYWORD_CLASS_NAME = "CustomKeywords";
    private static EntityController _instance;

    private KeywordController() {
    }

    public static KeywordController getInstance() {
        if (_instance == null) {
            _instance = new KeywordController();
        }
        return (KeywordController)_instance;
    }

    public List<KeywordClass> getBuiltInKeywordClasses() {
        List keywordClasses = BuiltInMethodNodeFactory.getKeywordClasses();
        boolean isTestNGPluginInstalled = BuiltinPluginUtil.isTestNGPluginInstalled();
        if (isTestNGPluginInstalled) {
            return keywordClasses;
        }
        ArrayList<KeywordClass> filteredClasses = new ArrayList<KeywordClass>();
        for (KeywordClass keywordClass : keywordClasses) {
            if (TESTNG_BUILTIN_KEYWORDS_CLASS_NAME.equals(keywordClass.getSimpleName())) continue;
            filteredClasses.add(keywordClass);
        }
        return filteredClasses;
    }

    public KeywordClass getBuiltInKeywordClassByName(String builtInKeywordClassName) {
        return BuiltInMethodNodeFactory.findClass((String)builtInKeywordClassName);
    }

    public boolean isCustomKeywordClass(String className) {
        if (className == null || className.isEmpty()) {
            return false;
        }
        return CustomMethodNodeFactory.getInstance().isCustomKeywordClass(className);
    }

    public boolean isBuiltinKeywordClassName(String className) {
        if (className == null || className.isEmpty()) {
            return false;
        }
        return BuiltInMethodNodeFactory.findClass((String)className) != null;
    }

    public KeywordMethod getBuiltInKeywordByName(String className, String keywordName, String[] paramTypes) {
        return BuiltInMethodNodeFactory.findMethod((String)className, (String)keywordName, (String[])paramTypes);
    }

    public KeywordMethod getBuiltInKeywordByName(KeywordClass keywordClass, String keywordName) {
        return BuiltInMethodNodeFactory.findMethod((String)keywordClass.getType().getName(), (String)keywordName, null);
    }

    public KeywordMethod getBuiltInKeywordByName(String className, String keywordName) {
        return BuiltInMethodNodeFactory.findMethod((String)className, (String)keywordName, null);
    }

    public List<KeywordMethod> getBuiltInKeywords(String builtInKeywordClassName) {
        return BuiltInMethodNodeFactory.getFilteredMethods((String)builtInKeywordClassName);
    }

    public List<KeywordMethod> getBuiltInKeywords(String builtInKeywordClassName, boolean excludeFlowControl) {
        return BuiltInMethodNodeFactory.getFilteredMethods((String)builtInKeywordClassName, (boolean)excludeFlowControl);
    }

    public List<MethodNode> getCustomKeywords(ProjectEntity project) {
        return ImprovedCustomKeywordParser.getInstance().getAllMethodNodes(GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project));
    }

    public MethodNode getCustomKeywordByName(String className, String methodName, ProjectEntity project) {
        List<MethodNode> methodNodes = this.getCustomKeywords(project);
        if (methodNodes != null && methodNodes.size() > 0) {
            for (MethodNode methodNode : methodNodes) {
                if (!methodNode.getDeclaringClass().getNameWithoutPackage().equals(className) && !methodNode.getDeclaringClass().getName().equals(className) || !methodNode.getName().equals(this.getRawCustomKeywordName(methodName))) continue;
                return methodNode;
            }
        }
        return null;
    }

    public String getRawCustomKeywordName(String customKeywordName) {
        return customKeywordName.replace("'", "").replace("\"", "");
    }

    public String getCustomKeywordName(String customKeywordName) {
        if (!customKeywordName.startsWith("'") && !customKeywordName.startsWith("\"")) {
            return "'" + customKeywordName + "'";
        }
        return customKeywordName;
    }

    public void parseAllCustomKeywordsWithoutRefreshing(ProjectEntity project) throws Exception {
        IFolder srcFolder = GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)project);
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        CustomKeywordParser.getInstance().parseProjectCustomKeywords(srcFolder, libFolder);
    }

    public void parseAllCustomKeywords(ProjectEntity project, IProgressMonitor monitor) throws Exception {
        ImprovedKeywordControllerDelegate.parseAllCustomKeywords(project, monitor);
    }

    public void parseAllCustomKeywords(ProjectEntity project, IProgressMonitor monitor, boolean isReload) throws Exception {
        ImprovedKeywordControllerDelegate.parseAllCustomKeywords(project, monitor, isReload);
    }

    public void parsePluginCustomKeywords(ProjectEntity project, IProgressMonitor monitor) throws Exception {
        ImprovedKeywordControllerDelegate.parsePluginCustomKeywords(project, monitor);
    }

    public void parseCustomKeywordFile(IFile file, ProjectEntity project) throws Exception {
        ImprovedKeywordControllerDelegate.parseCustomKeywordFile(file, project);
    }

    public void removeMethodNodesCustomKeywordFile(IFile file, ProjectEntity project) throws Exception {
        ImprovedKeywordControllerDelegate.removeKeywordClassesByFile(file, project);
    }

    public void parseCustomKeywordInPackage(IPackageFragment packageFragment, ProjectEntity project) throws Exception {
        ImprovedKeywordControllerDelegate.parseCustomKeywordInPackage(packageFragment, project);
    }
}

