/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.dal.TestSuiteCollectionDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TestSuiteCollectionController
extends EntityController {
    private static TestSuiteCollectionController instance;

    private TestSuiteCollectionController() {
    }

    public static TestSuiteCollectionController getInstance() {
        if (instance == null) {
            instance = new TestSuiteCollectionController();
        }
        return instance;
    }

    public TestSuiteCollectionEntity getTestSuiteCollection(String id) throws DALException {
        return this.getTestSuiteCollectionDataProvider().get(id);
    }

    public List<TestSuiteCollectionEntity> getAllTestSuiteCollectionsInProject(ProjectEntity project) throws DALException {
        return this.getTestSuiteCollectionDataProvider().getAll(project);
    }

    private TestSuiteCollectionDataProvider getTestSuiteCollectionDataProvider() {
        return TestSuiteCollectionController.getDataProviderSetting().getTestSuiteCollectionDataProvider();
    }

    public TestSuiteCollectionEntity getTestRunByDisplayId(String testSuiteCollectionDisplayId) throws DALException {
        if (testSuiteCollectionDisplayId == null) {
            return null;
        }
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        String projectDir = currentProject.getFolderLocation();
        String id = projectDir + File.separator + testSuiteCollectionDisplayId.replace("/", File.separator) + ".ts";
        return this.getTestSuiteCollectionDataProvider().get(id);
    }

    public TestSuiteCollectionEntity newTestSuiteCollection(FolderEntity parentFolder, String newName) throws DALException, FilePathTooLongException {
        return this.getTestSuiteCollectionDataProvider().add(parentFolder, newName);
    }

    public void updateTestSuiteCollection(TestSuiteCollectionEntity testSuiteCollection) throws DALException {
        this.getTestSuiteCollectionDataProvider().update(testSuiteCollection);
    }

    public void renameTestSuiteCollection(String newName, TestSuiteCollectionEntity testSuiteCollection) throws DALException, FilePathTooLongException {
        this.getTestSuiteCollectionDataProvider().rename(testSuiteCollection.getId(), newName);
    }

    public void deleteTestSuiteCollection(TestSuiteCollectionEntity testSuiteCollection) throws DALException {
        this.getTestSuiteCollectionDataProvider().delete(testSuiteCollection.getId());
    }

    public TestSuiteCollectionEntity moveTestSuiteCollection(TestSuiteCollectionEntity testSuiteCollection, FolderEntity newLocation) throws DALException, FilePathTooLongException {
        return this.getTestSuiteCollectionDataProvider().move(testSuiteCollection.getId(), newLocation);
    }

    public TestSuiteCollectionEntity copyTestSuiteCollection(TestSuiteCollectionEntity testSuiteCollection, FolderEntity newLocation) throws DALException, FilePathTooLongException {
        return this.getTestSuiteCollectionDataProvider().copy(testSuiteCollection.getId(), newLocation);
    }

    public List<TestSuiteCollectionEntity> updateProfileNameInAllTestSuiteCollections(ProjectEntity project, String oldProfileName, String newProfileName) throws DALException {
        List<TestSuiteCollectionEntity> testSuiteCollections = this.getAllTestSuiteCollectionsInProject(project);
        ArrayList<TestSuiteCollectionEntity> updated = new ArrayList<TestSuiteCollectionEntity>();
        for (TestSuiteCollectionEntity testSuiteCollection : testSuiteCollections) {
            List testSuiteRunConfigurations = testSuiteCollection.getTestSuiteRunConfigurations();
            boolean profileFound = false;
            for (TestSuiteRunConfiguration testSuiteRunConfiguration : testSuiteRunConfigurations) {
                String profileName = testSuiteRunConfiguration.getConfiguration().getProfileName();
                if (!profileName.equals(oldProfileName)) continue;
                testSuiteRunConfiguration.getConfiguration().setProfileName(newProfileName);
                profileFound = true;
            }
            if (!profileFound) continue;
            this.updateTestSuiteCollection(testSuiteCollection);
            updated.add(testSuiteCollection);
        }
        return updated;
    }
}

