/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.controls;

import com.kms.katalon.composer.components.constants.ComposerComponentsMessageConstants;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.tracking.service.Trackings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class HelpToolItem
extends ToolItem {
    private String documentationLink;

    public HelpToolItem(ToolBar parent, String documentationLink) {
        this(parent, documentationLink, "");
    }

    public HelpToolItem(ToolBar parent, String documentationLink, String label) {
        super(parent, 8);
        this.documentationLink = documentationLink;
        this.setImage(ImageManager.getImage((String)"help_16.png"));
        this.setToolTipText(ComposerComponentsMessageConstants.TOOLTIP_HELP_WITH_DOCUMENTATION);
        this.setText(label);
        this.addSelectionListener(this.getSelectionListener());
    }

    protected SelectionListener getSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HelpToolItem.this.openBrowserToLink(HelpToolItem.this.getDocumentationUrl());
            }
        };
    }

    protected void openBrowserToLink(String url) {
        Program.launch((String)url);
        Trackings.trackOpenHelp((String)url);
    }

    private String getDocumentationUrl() {
        return this.documentationLink;
    }

    protected void checkSubclass() {
    }
}

