/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.controls;

import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import java.util.Objects;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class SimpleTextField
extends Composite {
    private Label label;
    private TextField input;
    private int style;

    public SimpleTextField(Composite parent, int style) {
        super(parent, 0);
        this.style = style;
        this.init(this);
    }

    private void init(Composite parent) {
        this.label = ComponentBuilder.label(parent).fontSize(10).build();
        this.input = ComponentBuilder.textField(parent, 0x10000 | this.style).build();
        ComponentBuilder.fromGrid(parent).gridSpacing(ComponentUtil.applyZoom(2)).build();
        parent.pack();
    }

    public void setForeground(Color color) {
        if (Objects.nonNull((Object)this.input)) {
            this.input.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        this.label.setBackground(color);
        this.input.setBackground(color);
        super.setBackground(color);
    }

    public void setEnabled(boolean enabled) {
        this.input.setEnabled(enabled);
        this.label.setForeground(ColorUtil.themeColor("#919299", "#919299"));
        super.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.input.setFocus();
    }

    public boolean forceFocus() {
        return this.input.forceFocus();
    }

    public void setMessage(String message) {
        this.label.setText(message);
    }

    public String getText() {
        return this.input.getText();
    }

    public void setText(String text) {
        this.input.setText(text);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.input.addVerifyListener(listener);
    }
}

