/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class PreferencePageWithHelp
extends PreferencePage {
    private IPreferenceStore preferenceStore;
    private boolean isValid = true;
    private Control body;
    private boolean createApplyButton = true;
    private boolean createDefaultButton = true;
    private Button defaultsButton = null;
    private boolean createApplyButtonInformation = false;
    private IPreferencePageContainer container = null;
    private Button applyButton = null;
    private Label descriptionLabel;
    private Point size = null;

    protected PreferencePageWithHelp() {
        this("");
    }

    protected PreferencePageWithHelp(String title) {
        super(title);
    }

    protected PreferencePageWithHelp(String title, ImageDescriptor image) {
        super(title, image);
    }

    public Point computeSize() {
        if (this.size != null) {
            return this.size;
        }
        Control control = this.getControl();
        if (control != null) {
            this.size = this.doComputeSize();
            return this.size;
        }
        return new Point(0, 0);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.applyDialogFont(content);
        this.initializeDialogUnits((Control)content);
        this.descriptionLabel = this.createDescriptionLabel(content);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setLayoutData((Object)new GridData(768));
        }
        this.body = this.createContents(content);
        if (this.body != null) {
            this.body.setLayoutData((Object)new GridData(1808));
        }
        Composite buttonBar = this.createDefaultButtonBarComposite(content);
        this.contributeButtons(buttonBar);
        if (this.createApplyButton || this.createDefaultButton || this.createApplyButtonInformation) {
            GridLayout gridLayout;
            Composite leftColumnContainer;
            GridLayout buttonBarLayout = (GridLayout)buttonBar.getLayout();
            buttonBarLayout.numColumns = buttonBarLayout.numColumns + (this.createDefaultButton ? 1 : 0);
            buttonBarLayout.numColumns = buttonBarLayout.numColumns + (this.createApplyButtonInformation ? 1 : 0);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            if (this.createDefaultButton) {
                leftColumnContainer = new Composite(buttonBar, 0);
                leftColumnContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                gridLayout = new GridLayout(1, false);
                gridLayout.marginWidth = 0;
                gridLayout.horizontalSpacing = 0;
                gridLayout.marginHeight = 0;
                gridLayout.verticalSpacing = 0;
                leftColumnContainer.setLayout((Layout)gridLayout);
                this.renderDefaultButton(leftColumnContainer, widthHint);
            }
            if (this.createApplyButtonInformation) {
                leftColumnContainer = new Composite(buttonBar, 0);
                leftColumnContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                leftColumnContainer.setLayout((Layout)new GridLayout(1, false));
                this.renderInformation(leftColumnContainer);
            }
            if (this.createApplyButton) {
                Composite rightColumnContainer = new Composite(buttonBar, 0);
                rightColumnContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000000, !this.createDefaultButton, false));
                gridLayout = new GridLayout(1, false);
                gridLayout.marginWidth = 0;
                gridLayout.horizontalSpacing = 0;
                gridLayout.marginHeight = 0;
                gridLayout.verticalSpacing = 0;
                rightColumnContainer.setLayout((Layout)gridLayout);
                this.renderApplyButton(rightColumnContainer, widthHint);
            }
            this.applyDialogFont(buttonBar.getParent());
        } else if (buttonBar.getChildren().length < 1) {
            buttonBar.dispose();
        }
    }

    protected void renderDefaultButton(Composite container, int widthHint) {
        String label = this.getDefaultButtonLabel();
        this.defaultsButton = new Button(container, 8);
        this.defaultsButton.setText(label);
        Dialog.applyDialogFont((Control)this.defaultsButton);
        Point minButtonSize = this.defaultsButton.computeSize(-1, -1, true);
        GridData data = new GridData(0x1000008, 4, true, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        this.defaultsButton.setLayoutData((Object)data);
        this.defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageWithHelp.this.performDefaults();
            }
        });
    }

    protected void renderInformation(Composite container) {
    }

    protected void renderApplyButton(Composite container, int widthHint) {
        String label = this.getApplyButtonLabel();
        this.applyButton = new Button(container, 8);
        this.applyButton.setText(label);
        Dialog.applyDialogFont((Control)this.applyButton);
        Point minButtonSize = this.applyButton.computeSize(-1, -1, true);
        GridData data = new GridData(0x1000008, 4, true, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        this.applyButton.setLayoutData((Object)data);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageWithHelp.this.performApply();
            }
        });
        this.applyButton.setEnabled(this.isValid());
    }

    protected String getDefaultButtonLabel() {
        return JFaceResources.getString((String)"defaults");
    }

    protected String getApplyButtonLabel() {
        return JFaceResources.getString((String)"apply");
    }

    protected Composite createDefaultButtonBarComposite(Composite content) {
        Composite buttonBar = new Composite(content, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        buttonBar.setLayout((Layout)gridLayout);
        GridData gData = new GridData(4, 4, true, false);
        buttonBar.setLayoutData((Object)gData);
        return buttonBar;
    }

    public boolean hasDocumentation() {
        return false;
    }

    public String getDocumentationUrl() {
        return "";
    }

    protected Point doComputeSize() {
        if (this.descriptionLabel != null && this.body != null) {
            Point bodySize = this.body.computeSize(-1, -1, true);
            GridData gd = (GridData)this.descriptionLabel.getLayoutData();
            gd.widthHint = bodySize.x;
        }
        return this.getControl().computeSize(-1, -1, true);
    }

    public IPreferencePageContainer getContainer() {
        return this.container;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = this.doGetPreferenceStore();
        }
        if (this.preferenceStore != null) {
            return this.preferenceStore;
        }
        if (this.container != null) {
            return this.container.getPreferenceStore();
        }
        return null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void noDefaultAndApplyButton() {
        this.createApplyButton = false;
        this.createDefaultButton = false;
    }

    protected void noDefaultButton() {
        this.createDefaultButton = false;
    }

    protected void createApplyButtonInformation() {
        this.createApplyButtonInformation = true;
    }

    public void setContainer(IPreferencePageContainer container) {
        this.container = container;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
    }

    public void setSize(Point uiSize) {
        Control control = this.getControl();
        if (control != null) {
            control.setSize(uiSize);
            this.size = uiSize;
        }
    }

    public void setValid(boolean b) {
        boolean oldValue = this.isValid;
        this.isValid = b;
        if (oldValue != this.isValid) {
            if (this.getContainer() != null) {
                this.getContainer().updateButtons();
            }
            this.updateApplyButton();
        }
    }

    protected void updateApplyButton() {
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.isValid());
        }
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = new Composite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        messageComposite.setLayoutData((Object)new GridData(256));
        messageComposite.setFont(font);
        Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        return messageComposite;
    }

    protected Button getApplyButton() {
        return this.applyButton;
    }

    protected Button getDefaultsButton() {
        return this.defaultsButton;
    }
}

