/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.constants.DialogType;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.AnimationUtil;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DialogUtil {
    public static final int STYLE_CLOSE_TITLE_ONTOP = 16480;
    public static final int STYLE_TITLE_ONTOP = 16416;
    public static final int MAX_SEARCH_HIERARCHY_DEPTH = 15;

    public static void recenter5(Shell shell) {
        shell.pack();
        shell.setLocation(DialogUtil.computeCenterUpperLocation(shell.getSize(), 0.5));
    }

    public static void recenter5(Shell shell, Shell parentShell) {
        shell.pack();
        shell.setLocation(DialogUtil.computeCenterUpperLocation(shell.getSize(), 0.5, parentShell));
    }

    public static void recenter(Shell shell) {
        shell.pack();
        shell.setLocation(DialogUtil.computeCenterLocation(shell.getSize()));
    }

    public static void recenter(Shell shell, Shell parentShell) {
        shell.pack();
        shell.setLocation(DialogUtil.computeCenterLocation(shell.getSize(), parentShell));
    }

    public static Point computeCenterLocation(Point initialSize) {
        return DialogUtil.computeCenterLocation(initialSize, null);
    }

    public static Point computeCenterLocation(Point initialSize, Shell parent) {
        Rectangle parentBounds = DialogUtil.getParentBounds(parent);
        int left = (parentBounds.width - initialSize.x) / 2 + parentBounds.x;
        int top = (parentBounds.height - initialSize.y) / 2 + parentBounds.y;
        return new Point(left, top);
    }

    public static Point computeCenterUpperLocation(Point initialSize, double percent) {
        return DialogUtil.computeCenterUpperLocation(initialSize, percent, null);
    }

    public static Point computeCenterUpperLocation(Point initialSize, double percent, Shell parent) {
        Point leftTop = DialogUtil.computeCenterLocation(initialSize, parent);
        int top = (int)Math.round((double)leftTop.y * percent);
        return new Point(leftTop.x, top);
    }

    public static Point computeLeftLocation(Point initialSize) {
        return DialogUtil.computeLeftLocation(initialSize, null);
    }

    public static Point computeLeftLocation(Point initialSize, Shell parent) {
        Rectangle parentBounds = DialogUtil.getParentBounds(parent);
        int left = parentBounds.x;
        int top = (parentBounds.height - initialSize.y) / 2 + parentBounds.y;
        return new Point(left, top);
    }

    public static Point computeRightLocation(Point initialSize) {
        return DialogUtil.computeRightLocation(initialSize, null);
    }

    public static Point computeRightLocation(Point initialSize, Shell parent) {
        Rectangle parentBounds = DialogUtil.getParentBounds(parent);
        int left = parentBounds.x + (parentBounds.width - initialSize.x);
        int top = (parentBounds.height - initialSize.y) / 2 + parentBounds.y;
        return new Point(left, top);
    }

    public static Rectangle getParentBounds() {
        return DialogUtil.getParentBounds(null);
    }

    public static Rectangle getParentBounds(Shell parentShell) {
        Rectangle parentBounds = parentShell != null ? parentShell.getBounds() : Display.getCurrent().getBounds();
        return parentBounds;
    }

    public static void activateShell(Shell shell) {
        if (shell == null) {
            return;
        }
        UISynchronizeService.syncExec(() -> {
            if (SystemUtils.IS_OS_WINDOWS) {
                if (!shell.getMinimized()) {
                    shell.setMinimized(true);
                }
                shell.setMinimized(false);
                shell.setActive();
            } else {
                shell.forceActive();
            }
        });
    }

    public static ScrolledComposite autoScroll(Composite container) {
        return DialogUtil.autoScroll(container, 768);
    }

    public static ScrolledComposite autoScroll(final Composite container, int style) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(container.getParent(), style);
        scrolledComposite.setAlwaysShowScrollBars(false);
        scrolledComposite.setLayoutData(container.getLayoutData());
        container.setParent((Composite)scrolledComposite);
        scrolledComposite.setContent((Control)container);
        ComponentUtil.traverseToTop((Control)container, control -> control.pack());
        Point shellSize = container.getShell().getSize();
        Point contentSize = container.getSize();
        final int shellDiffWidth = shellSize.x - contentSize.x;
        final int shellDiffHeight = shellSize.y - contentSize.y;
        scrolledComposite.setMinSize(container.getSize().x, container.getSize().y);
        Listener overflowAutoListener = new Listener(){

            public void handleEvent(Event event) {
                Point contentSize = container.computeSize(-1, -1);
                Point currentShellSize = container.getShell().getSize();
                boolean shouldFillHorizontal = currentShellSize.x - shellDiffWidth >= contentSize.x;
                scrolledComposite.setExpandHorizontal(shouldFillHorizontal);
                boolean shouldFillVertical = currentShellSize.y - shellDiffHeight >= contentSize.y;
                scrolledComposite.setExpandVertical(shouldFillVertical);
            }
        };
        overflowAutoListener.handleEvent(null);
        container.getShell().addListener(11, overflowAutoListener);
        return scrolledComposite;
    }

    public static ScrolledComposite autoScroll(final Composite container, int style, boolean checkBeforePack) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(container.getParent(), style);
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setLayoutData(container.getLayoutData());
        container.setParent((Composite)scrolledComposite);
        scrolledComposite.setContent((Control)container);
        ComponentUtil.traverseToTop((Control)container, control -> {
            if (!(control instanceof Shell)) {
                control.pack();
            }
        });
        Point shellSize = container.getShell().getSize();
        Point contentSize = container.getSize();
        final int shellDiffWidth = shellSize.x - contentSize.x;
        final int shellDiffHeight = shellSize.y - contentSize.y;
        scrolledComposite.setMinSize(container.getSize().x, container.getSize().y);
        Listener overflowAutoListener = new Listener(){

            public void handleEvent(Event event) {
                Point contentSize = container.computeSize(-1, -1);
                Point currentShellSize = container.getShell().getSize();
                boolean shouldFillHorizontal = currentShellSize.x - shellDiffWidth >= contentSize.x;
                scrolledComposite.setExpandHorizontal(shouldFillHorizontal);
                boolean shouldFillVertical = currentShellSize.y - shellDiffHeight >= contentSize.y;
                scrolledComposite.setExpandVertical(shouldFillVertical);
            }
        };
        overflowAutoListener.handleEvent(null);
        container.getShell().addListener(11, overflowAutoListener);
        return scrolledComposite;
    }

    public static boolean isInNormalSize(Shell shell) {
        return !shell.getMaximized() && !shell.getMinimized();
    }

    public static void restore(Shell shell) {
        if (shell.getMaximized()) {
            shell.setMaximized(false);
        }
        if (shell.getMinimized()) {
            shell.setMinimized(false);
        }
    }

    public static Rectangle calcBestPopoverPosition(Rectangle targetArea, Rectangle dialogArea) {
        return DialogUtil.calcBestPopoverPosition(targetArea, dialogArea, 17408);
    }

    public static Rectangle calcBestPopoverPosition(Rectangle targetArea, Rectangle dialogArea, int preferedPosition) {
        int y;
        int spacingX = 5;
        int spacingY = 8;
        int bottom = targetArea.y + targetArea.height + spacingY;
        int left = targetArea.x - spacingX;
        int right = targetArea.x + targetArea.width - dialogArea.width - spacingX;
        int top = targetArea.y - dialogArea.height - spacingY;
        int center = targetArea.x + (targetArea.width - dialogArea.width) / 2;
        int middle = targetArea.y + (targetArea.height - dialogArea.height) / 2;
        int insetBottom = targetArea.y + targetArea.height - dialogArea.height - spacingY;
        Rectangle bottomLeft = new Rectangle(left, bottom, dialogArea.width, dialogArea.height);
        Rectangle bottomRight = new Rectangle(right, bottom, dialogArea.width, dialogArea.height);
        Rectangle topLeft = new Rectangle(left, top, dialogArea.width, dialogArea.height);
        Rectangle topRight = new Rectangle(right, top, dialogArea.width, dialogArea.height);
        Rectangle insetBottomCenter = new Rectangle(center, insetBottom, dialogArea.width, dialogArea.height);
        int x = ControlUtil.checkStyle(preferedPosition, 147456) ? (ControlUtil.checkStyle(preferedPosition, 16384) ? left : right) : center;
        Rectangle preferedArea = new Rectangle(x, y = ControlUtil.checkStyle(preferedPosition, 1152) ? (ControlUtil.checkStyle(preferedPosition, 128) ? top : bottom) : middle, dialogArea.width, dialogArea.height);
        if (DialogUtil.isInsideScreen(preferedArea)) {
            return preferedArea;
        }
        if (DialogUtil.isInsideScreen(bottomLeft)) {
            return bottomLeft;
        }
        if (DialogUtil.isInsideScreen(bottomRight)) {
            return bottomRight;
        }
        if (DialogUtil.isInsideScreen(topLeft)) {
            return topLeft;
        }
        if (DialogUtil.isInsideScreen(topRight)) {
            return topRight;
        }
        if (DialogUtil.isInsideScreen(insetBottomCenter)) {
            return insetBottomCenter;
        }
        int bottomLeftArea = DialogUtil.calcVisibleArea(bottomLeft);
        int bottomRightArea = DialogUtil.calcVisibleArea(bottomRight);
        int topLeftArea = DialogUtil.calcVisibleArea(topLeft);
        int topRightArea = DialogUtil.calcVisibleArea(topRight);
        List<Integer> positionList = Arrays.asList(bottomLeftArea, bottomRightArea, topLeftArea, topRightArea);
        Rectangle[] positions = new Rectangle[]{bottomLeft, bottomRight, topLeft, topRight};
        int bestMatchIndex = positionList.indexOf(Collections.max(positionList));
        return positions[bestMatchIndex];
    }

    public static boolean isInsideScreen(Rectangle rect) {
        Rectangle screen = Display.getCurrent().getBounds();
        return screen.intersection(rect).equals((Object)rect);
    }

    public static int calcVisibleArea(Rectangle rect) {
        Rectangle screen = Display.getCurrent().getBounds();
        Rectangle visibleRect = screen.intersection(rect);
        return visibleRect.width * visibleRect.height;
    }

    public static void setCanClickOK(Shell shell, boolean canClickOK) {
        if (ControlUtil.isDisposed((Widget)shell)) {
            return;
        }
        shell.setData("control.data.canClickOK", (Object)canClickOK);
    }

    public static boolean getCanClickOK(Shell shell) {
        if (ControlUtil.isDisposed((Widget)shell)) {
            return false;
        }
        Object canClickOK = shell.getData("control.data.canClickOK");
        return canClickOK == null || (Boolean)canClickOK != false;
    }

    public static void setCanClose(Shell shell, boolean canClose) {
        if (ControlUtil.isDisposed((Widget)shell)) {
            return;
        }
        shell.setData("control.data.canClose", (Object)canClose);
    }

    public static boolean getCanClose(Shell shell) {
        if (ControlUtil.isDisposed((Widget)shell)) {
            return false;
        }
        Object canClose = shell.getData("control.data.canClose");
        return canClose == null || (Boolean)canClose != false;
    }

    public static void setCanCloseAndClickOK(Shell shell, boolean canCloseAndClickOK) {
        DialogUtil.setCanClose(shell, canCloseAndClickOK);
        DialogUtil.setCanClickOK(shell, canCloseAndClickOK);
    }

    public static void close(Shell shell) {
        if (!ControlUtil.isDisposed((Widget)shell)) {
            shell.close();
        }
    }

    public static void close(Dialog dialog) {
        if (!ControlUtil.isDisposed(dialog)) {
            DialogUtil.setCanClose(dialog.getShell(), true);
            dialog.close();
        }
    }

    public static Shell createDialogShell(Shell activeShell) {
        String os = Platform.getOS();
        if ("win32".equals(os) || "linux".equals(os)) {
            return null;
        }
        Shell dialogShell = new Shell();
        Rectangle activeShellSize = activeShell.getBounds();
        dialogShell.setLocation((activeShellSize.width - dialogShell.getBounds().width) / 2, (activeShellSize.height - dialogShell.getBounds().height) / 2);
        return dialogShell;
    }

    public static void createSafeProgressDialog(ISafeRunnableWithProgress runnable) {
        DialogUtil.createSafeProgressDialog(runnable, false);
    }

    public static void createSafeProgressDialog(ISafeRunnableWithProgress runnable, boolean cancelable) {
        try {
            DialogUtil.createProgressDialog(runnable, cancelable);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable cause = invocationTargetException.getCause();
            if (cause != null) {
                LoggerSingleton.logError(cause);
                DialogUtil.createErrorDialog(cause.getMessage());
            }
        }
        catch (InterruptedException interruptedException) {
            LoggerSingleton.logError(interruptedException);
        }
    }

    public static void createProgressDialog(ISafeRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        DialogUtil.createProgressDialog(runnable, false);
    }

    public static void createProgressDialog(ISafeRunnableWithProgress runnable, boolean cancelable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, monitor -> {
            try {
                try {
                    runnable.run(monitor);
                }
                catch (Exception error) {
                    throw new InvocationTargetException(error);
                }
            }
            finally {
                monitor.done();
            }
        });
    }

    public static void createErrorDialog(String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)message);
    }

    public static void hideOverlapedPopover(Shell targetDialog) {
        Shell[] shells;
        if (!DialogUtil.isPopover(targetDialog)) {
            return;
        }
        Rectangle targetRect = ComponentUtil.getScreenArea((Widget)targetDialog);
        if (targetRect == null) {
            return;
        }
        Shell[] shellArray = shells = Display.getCurrent().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shellI = shellArray[n2];
            Rectangle shellRect = ComponentUtil.getScreenArea((Widget)shellI);
            if (shellRect != null && targetRect.intersects(shellRect) && shellI.getAlpha() > 0 && targetDialog != shellI && DialogUtil.isPopover(shellI)) {
                AnimationUtil.fadeOut(shellI);
                ComponentDataUtil.set((Widget)shellI, "dialog.temporaryHidden", true);
            }
            ++n2;
        }
    }

    public static void restoreOverlapedPopover(Shell targetDialog) {
        Shell[] shells;
        if (!DialogUtil.isPopover(targetDialog)) {
            return;
        }
        Shell[] shellArray = shells = Display.getCurrent().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shellI = shellArray[n2];
            if (shellI.getAlpha() == 0 && targetDialog != shellI && DialogUtil.isPopover(shellI) && ComponentDataUtil.getBoolean((Widget)shellI, "dialog.temporaryHidden")) {
                AnimationUtil.fadeIn(shellI);
            }
            ++n2;
        }
    }

    public static boolean isPopover(Shell targetDialog) {
        return DialogUtil.getType(targetDialog) == DialogType.POPOVER;
    }

    public static void setType(Shell targetDialog, DialogType type) {
        ComponentDataUtil.set((Widget)targetDialog, "dialog.type", (Object)type);
    }

    public static DialogType getType(Shell targetDialog) {
        return ComponentDataUtil.get((Widget)targetDialog, "dialog.type", DialogType.DIALOG);
    }

    public static void setDefaultButton(Button button) {
        button.getShell().setDefaultButton(button);
        button.setFocus();
    }

    public static ScrolledComposite findScrolledComposite(Control control) {
        if (control == null || control.isDisposed()) {
            return null;
        }
        Composite current = control.getParent();
        int depth = 0;
        HashSet<Composite> visited = new HashSet<Composite>();
        while (current != null && depth < 15) {
            if (visited.contains(current)) {
                return null;
            }
            visited.add(current);
            if (current instanceof ScrolledComposite) {
                return (ScrolledComposite)current;
            }
            if (!(current.getParent() instanceof Composite)) break;
            current = current.getParent();
            ++depth;
        }
        return null;
    }

    public static Listener autoUpdateScrolledCompositeListener(ScrolledComposite scrolledComposite) {
        return event -> {
            if (scrolledComposite == null || scrolledComposite.isDisposed()) {
                LoggerSingleton.logInfo("The nearest scrolled composite is not exist or is disposed");
                return;
            }
            Control content = scrolledComposite.getContent();
            if (content == null || content.isDisposed()) {
                LoggerSingleton.logInfo("The scrolled composite's content is not exist or is disposed");
                return;
            }
            try {
                int width = scrolledComposite.getClientArea().width;
                int height = scrolledComposite.getContent().computeSize((int)-1, (int)-1).y;
                scrolledComposite.setMinSize(width, height);
                scrolledComposite.layout(true, true);
            }
            catch (Exception e) {
                LoggerSingleton.logError("Failed to update scrolled composite for container: ");
                LoggerSingleton.logError(e);
            }
        };
    }

    public static interface ISafeRunnableWithProgress {
        public void run(IProgressMonitor var1) throws Exception;
    }
}

