/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.wizard;

import com.kms.katalon.composer.components.constants.StringConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.components.wizard.WizardPage;
import com.kms.katalon.controller.EntityNameController;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewNamePage
extends WizardPage {
    private static final String NEW_NAME_PAGE_DESCRIPTION_TEMPLATE = StringConstants.WIZ_NEW_NAME_PAGE_DESCRIPTION_TEMPLATE;
    private static final String LABEL_NEW_NAME_TEXT = StringConstants.WIZ_LABEL_NEW_NAME_TEXT;
    private static final String NEW_NAME_PAGE_TITLE = StringConstants.WIZ_NEW_NAME_PAGE_TITLE;
    private Text txtName;
    private Composite container;
    private ITreeEntity treeEntity;

    public NewNamePage() {
        super(NewNamePage.class.getSimpleName(), NEW_NAME_PAGE_TITLE);
    }

    public void createControl(Composite parent) {
        try {
            this.treeEntity = ((RenameWizard)this.getWizard()).getTreeEntity();
            String typeName = this.treeEntity.getTypeName();
            this.setTitle(typeName);
            this.setMessage(MessageFormat.format(NEW_NAME_PAGE_DESCRIPTION_TEMPLATE, typeName, typeName), 1);
            this.container = new Composite(parent, 0);
            this.container.setLayout((Layout)new GridLayout(2, false));
            Label lblNewName = new Label(this.container, 0);
            lblNewName.setText(LABEL_NEW_NAME_TEXT);
            this.txtName = new Text(this.container, 2052);
            this.txtName.setText(this.treeEntity.getText());
            this.txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        if (NewNamePage.this.canFlipToNextPage()) {
                            NewNamePage.this.setErrorMessage(null);
                            ((RenameWizard)NewNamePage.this.getWizard()).setNewNameValue(NewNamePage.this.getNewName());
                            NewNamePage.this.setPageComplete(true);
                        } else {
                            NewNamePage.this.setPageComplete(false);
                        }
                    }
                    catch (Exception exception) {
                        LoggerSingleton.getInstance().getLogger().error((Throwable)exception);
                    }
                }
            });
            GridData gd = new GridData(768);
            this.txtName.setLayoutData((Object)gd);
            this.setControl((Control)this.container);
            this.setPageComplete(false);
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.validateName(this.treeEntity) && !this.isDuplicated();
    }

    private boolean validateName(ITreeEntity treeEntity) {
        try {
            String name = this.getNewName();
            EntityNameController.getInstance().validateName(name);
            return !StringUtils.equals((String)name, (String)treeEntity.getText());
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }

    private boolean isDuplicated() {
        boolean isDuplicated = ((RenameWizard)this.getWizard()).getExistingNames().contains(StringUtils.trim((String)this.getNewName()));
        if (isDuplicated) {
            this.setErrorMessage(StringConstants.WIZ_NAME_ALREADY_EXISTS);
        }
        return isDuplicated;
    }

    private String getNewName() {
        return this.txtName.getText();
    }
}

