/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.admin.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.admin.dto.AuthenticationTokenDto;
import com.kms.katalon.admin.dto.LicenseResourceDto;
import com.kms.katalon.admin.dto.UserInfoDto;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.InvalidRequestException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.model.exception.ServerErrorException;
import com.kms.katalon.network.core.model.exception.UrlInvalidException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.ActivationRequest;
import com.kms.katalon.session.core.model.ApiKey;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.LicenseResource;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.ResponsePage;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.model.exception.AuthenticationException;
import com.kms.katalon.session.core.model.exception.LicenseException;
import com.kms.katalon.session.core.model.exception.MultipleActivationException;
import com.kms.katalon.session.core.services.IAdminService;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class AdminService
implements IAdminService {
    private static final String ACTIVATE_HOSTNAME_PARAM = "hostname";
    private static final String ACTIVATE_IDP_TYPE_PARAM = "idpType";
    private static final String ACTIVATE_KS_EDITION_PARAM = "katalonEdition";
    private static final String ACTIVATE_KS_VERSION_PARAM = "ksVersion";
    private static final String ACTIVATE_LICENSE_TYPE_PARAM = "licenseType";
    private static final String ACTIVATE_MACHINE_KEY_PARAM = "machineKey";
    private static final String ACTIVATE_ORGANIZATION_ID_PARAM = "organizationId";
    private static final String ACTIVATE_PACKAGE_PARAM = "package";
    private static final String ACTIVATE_SESSION_ID_PARAM = "sessionId";
    private static final String ACTIVATE_SUBDOMAIN_PARAM = "subdomain";
    private static final String GRANT_TYPE_PASSWORD = "password";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AUTHORIZATION_BASIC_PREFIX = "Basic";
    private static final Logger logger = LoggerFactory.getLogger(AdminService.class);
    private static final String OAUTH2_CLIENT_ID = "kit";
    private static final String OAUTH2_CLIENT_SECRET = "kit";
    private static final String TOKEN_GRANT_TYPE_PARAM = "grant_type";
    private static final String TOKEN_PASSWORD_PARAM = "password";
    private static final String TOKEN_USERNAME_PARAM = "username";
    private static final String ADMIN_INFO_PATH = "/info";
    private static final String ORGANIZATION_LIST_PATH = "/api/v1/organizations/list";
    private static final String SUBSCRIPTION_EXPIRATION_PATH = "/api/v1/subscription/expiration";
    private static final String TESTOPS_API_SEARCH = "/api/v1/search";
    @Inject
    IDiscoveryService discoveryService;
    @Inject
    IHttpClient httpClient;
    @Inject
    INetworkPreferences networkPreferences;

    public boolean testAdminConnection() throws URISyntaxException, NetworkErrorException, MalformedContentException {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.ADMIN);
        URI baseUri = new URI(baseUrl);
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(ADMIN_INFO_PATH).build();
        HashMap headers = new HashMap();
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException("Failed to check admin connection", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        JsonUtil.fromJson((String)response.getBody(), Object.class);
        return true;
    }

    public LicenseResource activate(ActivationRequest request) throws LicenseException {
        HttpResponse response;
        URI uri;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.ADMIN);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/license-keys/activate");
            uriBuilder.setParameter(ACTIVATE_MACHINE_KEY_PARAM, StringUtils.defaultString((String)request.getMachineId()));
            uriBuilder.setParameter(ACTIVATE_KS_VERSION_PARAM, StringUtils.defaultString((String)request.getKatalonVersion()));
            uriBuilder.setParameter(ACTIVATE_ORGANIZATION_ID_PARAM, StringUtils.defaultString((String)request.getOrganizationId()));
            uriBuilder.setParameter(ACTIVATE_SESSION_ID_PARAM, StringUtils.defaultString((String)request.getSessionId()));
            uriBuilder.setParameter(ACTIVATE_HOSTNAME_PARAM, StringUtils.defaultString((String)request.getHostname()));
            if (Objects.nonNull(request.getIdpType())) {
                uriBuilder.setParameter(ACTIVATE_IDP_TYPE_PARAM, StringUtils.defaultString((String)request.getIdpType().toString()));
            }
            if (Objects.nonNull(request.getSubdomain())) {
                uriBuilder.setParameter(ACTIVATE_SUBDOMAIN_PARAM, StringUtils.defaultString((String)request.getSubdomain()));
            }
            uriBuilder.setParameter(ACTIVATE_PACKAGE_PARAM, StringUtils.defaultString((String)request.getKatalonPackage().toString()));
            uriBuilder.setParameter(ACTIVATE_LICENSE_TYPE_PARAM, StringUtils.defaultString((String)request.getLicenseType()));
            uriBuilder.setParameter(ACTIVATE_KS_EDITION_PARAM, "STANDALONE");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            UrlInvalidException cause = new UrlInvalidException("Invalid authentication server URL!", (Throwable)e);
            throw new LicenseException("Failed to activate!", (Throwable)cause);
        }
        AuthenticationToken adminToken = request.getAdminToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        BearerAuthentication authentication = new BearerAuthentication(adminToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        try {
            response = this.httpClient.formPost(uri, new HashMap(), httpOptions);
        }
        catch (HttpException e) {
            throw new LicenseException("Failed to activate!", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        String responseBody = response.getBody();
        if (statusCode >= 400 && statusCode < 500) {
            if (statusCode == 400 && responseBody.contains("logged in on another machine")) {
                throw new MultipleActivationException(this.extractErrorMessage(responseBody));
            }
            String message = this.extractErrorMessage(responseBody);
            InvalidRequestException cause = new InvalidRequestException(message, statusCode);
            throw new LicenseException(message, (Throwable)cause);
        }
        if (statusCode >= 500 && statusCode < 600) {
            ServerErrorException cause = new ServerErrorException(this.extractErrorMessage(responseBody), statusCode);
            throw new LicenseException("Failed to activate!", (Throwable)cause);
        }
        try {
            LicenseResourceDto licenseResourceDto = (LicenseResourceDto)response.json(LicenseResourceDto.class);
            return licenseResourceDto.toDomainModel();
        }
        catch (MalformedContentException e) {
            throw new LicenseException("Failed to activate!", (Throwable)e);
        }
    }

    public String extractErrorMessage(String responseBody) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(responseBody);
            String message = rootNode.path("message").asText(null);
            if (message != null) {
                return message;
            }
            message = rootNode.path("error_description").asText(null);
            if (message != null) {
                return message;
            }
            return responseBody;
        }
        catch (Exception exception) {
            return responseBody;
        }
    }

    public AuthenticationToken getAdminToken(AuthenticationToken katOneToken) throws AuthenticationException, NetworkErrorException, MalformedContentException, UrlInvalidException, URISyntaxException {
        return this.getAdminToken("", "access_token_" + katOneToken.getAccessToken());
    }

    public AuthenticationToken getAdminToken(String apiKey) throws AuthenticationException, NetworkErrorException, MalformedContentException, UrlInvalidException, URISyntaxException {
        return this.getAdminToken("", apiKey);
    }

    public AuthenticationToken getAdminToken(String username, String password) throws AuthenticationException, NetworkErrorException, MalformedContentException, UrlInvalidException, URISyntaxException {
        return this.getAdminToken(null, username, password);
    }

    public AuthenticationToken getAdminToken(String serverUrl, String username, String password) throws AuthenticationException, NetworkErrorException, MalformedContentException, UrlInvalidException, URISyntaxException {
        String baseUrl = StringUtils.isNotBlank((CharSequence)serverUrl) ? serverUrl : this.discoveryService.getServerUrl(ServerType.ADMIN);
        URI baseUri = new URI(baseUrl);
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/oauth/token").build();
        HashMap<String, String> body = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            body.put(TOKEN_USERNAME_PARAM, username);
        }
        body.put("password", password);
        body.put(TOKEN_GRANT_TYPE_PARAM, "password");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        String clientCredentials = "kit:kit";
        headers.put(HEADER_AUTHORIZATION, HEADER_AUTHORIZATION_BASIC_PREFIX.trim() + " " + Base64.getEncoder().encodeToString(clientCredentials.getBytes()));
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.formPost(uri, body, httpOptions);
        }
        catch (HttpException e) {
            throw new AuthenticationException("Failed to request adminToken!", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        AuthenticationTokenDto authenticationTokenDto = (AuthenticationTokenDto)response.json(AuthenticationTokenDto.class);
        if (authenticationTokenDto == null) {
            throw new MalformedContentException("The API response is null or does not contain the expected content.");
        }
        return authenticationTokenDto.toDomainModel();
    }

    public String fetchApiKey(AuthenticationToken token) throws NetworkErrorException, MalformedContentException, URISyntaxException {
        List<ApiKey> apiKeys = this.fetchApiKeys(token);
        if (apiKeys == null || apiKeys.isEmpty()) {
            throw new MalformedContentException("No API keys found");
        }
        return apiKeys.stream().filter(Objects::nonNull).filter(apiKey -> apiKey.getExpiryDate() == null || apiKey.getExpiryDate().after(new Date())).findFirst().map(ApiKey::getKey).orElse(null);
    }

    private List<ApiKey> fetchApiKeys(AuthenticationToken token) throws URISyntaxException, NetworkErrorException, MalformedContentException {
        String query = JsonBuilder.object().property("type", (Object)"ApiKey").array("conditions", new Object[0]).array("functions", new Object[0]).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)0).property("size", (Object)5).array("sorts", new Object[]{"createdAt,asc"})).array("groupBys", new Object[0]).toJson();
        URI baseUri = new URI(this.discoveryService.getServerUrl(ServerType.TESTOPS));
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(TESTOPS_API_SEARCH).setParameter("q", query).build();
        HashMap headers = new HashMap();
        BearerAuthentication authentication = new BearerAuthentication(token.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException("Failed to get ApiKeys", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        ResponsePage responsePage = (ResponsePage)response.json((TypeReference)new TypeReference<ResponsePage<ApiKey>>(){});
        if (responsePage == null || responsePage.getContent() == null) {
            throw new MalformedContentException("The API response is null or does not contain the expected content.");
        }
        return responsePage.getContent();
    }

    public UserInfo getUserInfo(AuthenticationToken adminToken) throws UrlInvalidException, NetworkErrorException, MalformedContentException, URISyntaxException {
        return this.getUserInfo(null, adminToken);
    }

    public UserInfo getUserInfo(String serverUrl, AuthenticationToken adminToken) throws UrlInvalidException, NetworkErrorException, MalformedContentException, URISyntaxException {
        String baseUrl = StringUtils.isNotBlank((CharSequence)serverUrl) ? serverUrl : this.discoveryService.getServerUrl(ServerType.ADMIN);
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/users/me");
        URI uri = uriBuilder.build();
        HashMap headers = new HashMap();
        BearerAuthentication authentication = new BearerAuthentication(adminToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException("Failed to get userInfo!", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        UserInfoDto userInfoDto = (UserInfoDto)response.json(UserInfoDto.class);
        return userInfoDto.toDomainModel();
    }

    public void releaseLicense(ActivationRequest request) throws UrlInvalidException, NetworkErrorException {
        URI uri = null;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.ADMIN);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/license-keys/release");
            uriBuilder.setParameter(ACTIVATE_MACHINE_KEY_PARAM, StringUtils.defaultString((String)request.getMachineId()));
            uriBuilder.setParameter(ACTIVATE_KS_VERSION_PARAM, StringUtils.defaultString((String)request.getKatalonVersion()));
            uriBuilder.setParameter(ACTIVATE_ORGANIZATION_ID_PARAM, StringUtils.defaultString((String)request.getOrganizationId()));
            uriBuilder.setParameter(ACTIVATE_SESSION_ID_PARAM, StringUtils.defaultString((String)request.getSessionId()));
            uriBuilder.setParameter(ACTIVATE_HOSTNAME_PARAM, StringUtils.defaultString((String)request.getHostname()));
            uriBuilder.setParameter(ACTIVATE_PACKAGE_PARAM, StringUtils.defaultString((String)request.getKatalonPackage().toString()));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UrlInvalidException("Invalid server url!", (Throwable)e);
        }
        AuthenticationToken adminToken = request.getAdminToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        BearerAuthentication authentication = new BearerAuthentication(adminToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.formPost(uri, new HashMap(), httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException("Failed to deactivate!", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
    }

    public List<Organization> getOrganizations(String serverUrl, AuthenticationToken token) throws URISyntaxException, NetworkErrorException, MalformedContentException, AuthenticationException {
        String baseUrl = StringUtils.isNotBlank((CharSequence)serverUrl) ? serverUrl : this.discoveryService.getServerUrl(ServerType.ADMIN);
        URI baseUri = new URI(baseUrl);
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(ORGANIZATION_LIST_PATH).build();
        HashMap headers = new HashMap();
        BearerAuthentication authentication = new BearerAuthentication(token.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException("Failed to get organizations!", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return (List)response.json((TypeReference)new TypeReference<List<Organization>>(){});
    }

    public Date getExpirationOnline(AuthenticationToken token, Long organizationId, String licenseFeature) throws URISyntaxException, NetworkErrorException, MalformedContentException {
        URI baseUri = new URI(this.discoveryService.getServerUrl(ServerType.ADMIN));
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(SUBSCRIPTION_EXPIRATION_PATH).setParameter("feature", licenseFeature).setParameter(ACTIVATE_ORGANIZATION_ID_PARAM, Long.toString(organizationId)).build();
        HashMap headers = new HashMap();
        BearerAuthentication authentication = new BearerAuthentication(token.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException("Failed to get subscription expiration!", (Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return (Date)response.json((TypeReference)new TypeReference<Date>(){});
    }

    private void handleError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody));
    }

    private void handleServerError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody));
    }
}

