/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.factory;

import com.kms.katalon.custom.improvement.model.CustomKeywordClass;
import com.kms.katalon.custom.improvement.model.CustomKeywordFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomKeywordClassFactory {
    private static CustomKeywordClassFactory instance;
    private Map<CustomKeywordFile, List<CustomKeywordClass>> projectKeywordClassLookup = new HashMap<CustomKeywordFile, List<CustomKeywordClass>>();
    private Map<File, List<CustomKeywordClass>> pluginKeywordClassLookup = new HashMap<File, List<CustomKeywordClass>>();

    private CustomKeywordClassFactory() {
    }

    public static CustomKeywordClassFactory getInstance() {
        if (instance == null) {
            instance = new CustomKeywordClassFactory();
        }
        return instance;
    }

    public void addProjectKeywordClasses(CustomKeywordFile keywordFile, List<CustomKeywordClass> keywordClasses) {
        this.projectKeywordClassLookup.put(keywordFile, keywordClasses);
    }

    public void removeKeywordClassesByFile(CustomKeywordFile keywordFile) {
        this.projectKeywordClassLookup.remove(keywordFile);
    }

    public void addPluginKeywordClasses(File pluginFile, List<CustomKeywordClass> keywordClasses) {
        this.pluginKeywordClassLookup.put(pluginFile, keywordClasses);
    }

    public List<CustomKeywordClass> getAllKeywordClasses() {
        ArrayList<CustomKeywordClass> keywordClasses = new ArrayList<CustomKeywordClass>();
        for (List<CustomKeywordClass> keywordClassList : this.projectKeywordClassLookup.values()) {
            keywordClasses.addAll(keywordClassList);
        }
        for (List<CustomKeywordClass> keywordClassList : this.pluginKeywordClassLookup.values()) {
            keywordClasses.addAll(keywordClassList);
        }
        return new ArrayList<CustomKeywordClass>(keywordClasses);
    }

    public void reset() {
        this.projectKeywordClassLookup.clear();
        this.pluginKeywordClassLookup.clear();
    }
}

