/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webservice.configuration.impl;

import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.webservice.setting.WebServiceExecutionSettingStore;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WebServiceExecutionSetting
extends DefaultExecutionSetting {
    public WebServiceExecutionSettingStore getExecutionSettingStore() {
        return WebServiceExecutionSettingStore.getStore();
    }

    public Map<String, Object> getGeneralProperties() {
        Map generalProperties = super.getGeneralProperties();
        generalProperties.putAll(this.getWebServiceExecutionProperties());
        return generalProperties;
    }

    private Map<String, Object> getWebServiceExecutionProperties() {
        HashMap<String, Object> reportProps = new HashMap<String, Object>();
        WebServiceExecutionSettingStore executionSettingStore = this.getExecutionSettingStore();
        try {
            IExecutedEntity executedEntity = this.getExecutedEntity();
            long maxResponseSize = executionSettingStore.getMaxResponseSize();
            if (executedEntity instanceof TestSuiteExecutedEntity) {
                TestSuiteExecutedEntity testSuiteExecutedEntity = (TestSuiteExecutedEntity)executedEntity;
                maxResponseSize = testSuiteExecutedEntity.getWebServiceSettings().getMaxResponseSize();
            }
            reportProps.put("requestConnectionTimeout", executionSettingStore.getConnectionTimeout());
            reportProps.put("requestSocketTimeout", executionSettingStore.getSocketTimeout());
            reportProps.put("maxResponseSize", maxResponseSize);
        }
        catch (IOException error) {
            LogUtil.logError((Throwable)error);
        }
        return reportProps;
    }
}

