/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.filter;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumProxyBasicAuthorizationFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(SeleniumProxyBasicAuthorizationFilter.class);
    private String proxyUserName;
    private String proxyPassword;

    public SeleniumProxyBasicAuthorizationFilter(String proxyUserName, String proxyPassword) {
        this.proxyUserName = proxyUserName;
        this.proxyPassword = proxyPassword;
    }

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            try {
                if (StringUtils.isNotBlank((CharSequence)this.proxyUserName) && StringUtils.isNotBlank((CharSequence)this.proxyPassword)) {
                    String encoded = Base64.getEncoder().encodeToString(String.format("%s:%s", this.proxyUserName, this.proxyPassword).getBytes(StandardCharsets.UTF_8));
                    req.addHeader("Proxy-Authorization", "Basic " + encoded);
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                }
            }
            catch (Exception e) {
                logger.warn("Exception while apply AppiumAuthorizationFilter", (Throwable)e);
            }
            return next.execute(req);
        };
    }
}

