/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.entity;

import com.katalon.platform.api.model.Integration;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.platform.internal.entity.IntegrationImpl;
import com.kms.katalon.platform.internal.entity.VariableEntityImpl;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TestCaseEntityImpl
implements com.katalon.platform.api.model.TestCaseEntity {
    private final TestCaseEntity source;

    public TestCaseEntityImpl(TestCaseEntity source) {
        this.source = source;
    }

    public String getFileLocation() {
        return this.source.getId();
    }

    public String getFolderLocation() {
        return this.source.getParentFolder().getId();
    }

    public String getId() {
        return this.source.getIdForDisplay();
    }

    public String getName() {
        return this.source.getName();
    }

    public List<Integration> getIntegrations() {
        return this.source.getIntegratedEntities().stream().map(i -> new IntegrationImpl((IntegratedEntity)i)).collect(Collectors.toList());
    }

    public String getComment() {
        return this.source.getComment();
    }

    public String getDescription() {
        return this.source.getDescription();
    }

    public String getParentFolderId() {
        return this.source.getParentFolder().getIdForDisplay();
    }

    public Integration getIntegration(String integrationName) {
        if (StringUtils.isEmpty((CharSequence)integrationName)) {
            return null;
        }
        return this.source.getIntegratedEntities().stream().filter(i -> i.getProductName() != null && i.getProductName().equals(integrationName)).map(i -> new IntegrationImpl((IntegratedEntity)i)).findFirst().orElse(null);
    }

    public File getScriptFile() {
        try {
            String testCaseFilePath = TestCaseController.getInstance().getGroovyScriptFilePath(this.source);
            if (StringUtils.isNotEmpty((CharSequence)testCaseFilePath)) {
                return new File(testCaseFilePath);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTags() {
        return this.source.getTag();
    }

    public List<com.katalon.platform.api.model.VariableEntity> getVariables() {
        return this.source.getVariables().stream().map(v -> new VariableEntityImpl((VariableEntity)v)).collect(Collectors.toList());
    }
}

