/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.report;

import com.katalon.platform.api.report.TestCaseRecord;
import com.katalon.platform.api.report.TestSuiteRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.platform.internal.report.TestCaseRecordImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestSuiteRecordImpl
implements TestSuiteRecord {
    private final TestSuiteLogRecord source;
    private final ReportEntity report;
    private List<TestCaseRecord> childRecords;

    public TestSuiteRecordImpl(ReportEntity report, TestSuiteLogRecord source) {
        this.source = source;
        this.report = report;
    }

    public String getName() {
        return this.source.getName();
    }

    public String getDescription() {
        return this.source.getDescription();
    }

    public String getMessage() {
        return this.source.getMessage();
    }

    public long getStartTime() {
        return this.source.getStartTime();
    }

    public long getEndTime() {
        return this.source.getEndTime();
    }

    public String getReportId() {
        return this.report.getIdForDisplay();
    }

    public String getTestSuiteId() {
        return this.source.getId();
    }

    public List<TestCaseRecord> getTestCaseRecords() {
        if (this.source.getChildRecords() == null) {
            return Collections.emptyList();
        }
        if (this.childRecords == null) {
            this.childRecords = Arrays.asList(this.source.filterFinalTestCasesResult()).stream().map(child -> child instanceof TestCaseLogRecord ? new TestCaseRecordImpl((TestCaseLogRecord)child) : null).collect(Collectors.toList());
        }
        return this.childRecords;
    }

    public Map<String, String> getRunData() {
        return this.source.getRunData();
    }

    public List<String> getLogFiles() {
        return this.source.getLogFiles();
    }

    public List<String> getAttachments() {
        return Arrays.asList(this.source.getAttachments());
    }
}

