/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qas.api.ApiServiceResponse;
import org.qas.api.JsonMapper;
import org.qas.api.ResponseMetadata;
import org.qas.api.http.HttpResponse;
import org.qas.api.http.HttpResponseHandler;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.api.transform.Unmarshaller;
import org.qas.api.transform.VoidJsonUnmarshaller;

public class JsonResponseHandler<T>
implements HttpResponseHandler<ApiServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Logger LOG = Logger.getLogger(JsonResponseHandler.class.getName());
    private static JsonFactory jsonFactory = new JsonFactory();
    public boolean needsConnectionLeftOpen = false;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidJsonUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiServiceResponse<T> handle(HttpResponse response) throws Exception {
        if (LOG.isLoggable(Level.ALL)) {
            LOG.log(Level.ALL, "Parsing service response JSON");
        }
        JsonParser jsonParser = null;
        String data = null;
        if (this.responseUnmarshaller.isParseJson()) {
            data = JsonMapper.toString(((HttpURLConnection)response.getUnderlying()).getInputStream());
        }
        if (!this.needsConnectionLeftOpen) {
            jsonParser = jsonFactory.createParser(response.getContent());
        }
        try {
            ApiServiceResponse<T> awsResponse = new ApiServiceResponse<T>();
            JsonUnmarshallerContext unmarshallerContext = new JsonUnmarshallerContext(jsonParser, response);
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.isParseJson() ? this.responseUnmarshaller.parse(data) : this.responseUnmarshaller.unmarshall(unmarshallerContext);
            awsResponse.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            metadata.put("RequestId", this.getRequestId(response));
            awsResponse.setMetadata(new ResponseMetadata(metadata));
            if (LOG.isLoggable(Level.ALL)) {
                LOG.log(Level.ALL, "Done parsing service response");
            }
            ApiServiceResponse<T> apiServiceResponse = awsResponse;
            return apiServiceResponse;
        }
        finally {
            if (!this.needsConnectionLeftOpen) {
                try {
                    jsonParser.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    protected String getRequestId(HttpResponse response) {
        return response.getHeaders().get("x-qtest-request-id");
    }
}

