/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.auth;

import java.io.IOException;
import java.io.InputStream;
import org.qas.api.AuthClientException;
import org.qas.qtest.api.auth.PropertiesQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;

public class ClasspathPropertiesQTestCredentialsProvider
implements QTestCredentialsProvider {
    private static final String DEFAULT_PROPERTIES_FILE = "qTestCredentials.properties";
    private final String credentialsFilePath;

    public ClasspathPropertiesQTestCredentialsProvider() {
        this(DEFAULT_PROPERTIES_FILE);
    }

    public ClasspathPropertiesQTestCredentialsProvider(String credentialsFilePath) {
        if (credentialsFilePath == null) {
            throw new IllegalArgumentException("Credentials file path cannot be null.");
        }
        this.credentialsFilePath = !credentialsFilePath.startsWith("/") ? "/" + credentialsFilePath : credentialsFilePath;
    }

    @Override
    public QTestCredentials getCredentials() {
        InputStream inputStream = this.getClass().getResourceAsStream(this.credentialsFilePath);
        if (inputStream == null) {
            throw new AuthClientException("Unable to load qTest credentials from the " + this.credentialsFilePath + " file on the classpath");
        }
        try {
            return new PropertiesQTestCredentials(inputStream);
        }
        catch (IOException ioex) {
            throw new AuthClientException("Unable to load qTest credentials from the " + this.credentialsFilePath + " file on the classpath", ioex);
        }
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClasspathPropertiesQTestCredentialsProvider{");
        sb.append("credentialsFilePath='").append(this.credentialsFilePath).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

