/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.attachment;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.attachment.AttachmentService;
import org.qas.qtest.api.services.attachment.model.Attachment;
import org.qas.qtest.api.services.attachment.model.AttachmentRequest;
import org.qas.qtest.api.services.attachment.model.transform.AttachmentJsonUnmarshaller;
import org.qas.qtest.api.services.attachment.model.transform.AttachmentRequestMarshaller;

public class AttachmentServiceClient
extends QTestApiWebServiceClient<AttachmentServiceClient>
implements AttachmentService {
    public AttachmentServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public AttachmentServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public AttachmentServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public AttachmentServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public AttachmentServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public AttachmentServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public Attachment attach(AttachmentRequest attachmentRequest) throws AuthServiceException {
        try {
            Object request = new AttachmentRequestMarshaller().marshall(attachmentRequest);
            return this.invoke((Request)request, AttachmentJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during attach data to qTest service", ex);
        }
    }
}

