/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.client;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.api.transform.VoidJsonUnmarshaller;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.client.ClientService;
import org.qas.qtest.api.services.client.model.Client;
import org.qas.qtest.api.services.client.model.GetClientRequest;
import org.qas.qtest.api.services.client.model.SetSessionUrlRequest;
import org.qas.qtest.api.services.client.model.transform.ClientJsonUnmarshaller;
import org.qas.qtest.api.services.client.model.transform.GetClientRequestMarshaller;
import org.qas.qtest.api.services.client.model.transform.SetSessionUrlRequestMarshaller;

public class ClientServiceClient
extends QTestApiWebServiceClient<ClientServiceClient>
implements ClientService {
    public ClientServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public ClientServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public ClientServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public ClientServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public ClientServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public ClientServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public Client getClient(GetClientRequest getClientRequest) throws AuthServiceException {
        try {
            Object request = new GetClientRequestMarshaller().marshall(getClientRequest);
            return this.invoke((Request)request, ClientJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during getting client", ex);
        }
    }

    @Override
    public void setSessionUrl(SetSessionUrlRequest setSessionUrlRequest) throws AuthServiceException {
        try {
            Object request = new SetSessionUrlRequestMarshaller().marshall(setSessionUrlRequest);
            this.invoke((Request)request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during setting session URL", ex);
        }
    }
}

