/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.MoveTestCycleRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestCycleRequestMarshaller;

public final class MoveTestCycleRequestMarshaller
extends AbstractTestCycleRequestMarshaller<MoveTestCycleRequest> {
    @Override
    public Request marshall(MoveTestCycleRequest testCycleRequest) throws Exception {
        testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
        MoveTestCycleRequestMarshaller.validateProjectId(testCycleRequest.getProjectId());
        Long testCycleId = testCycleRequest.getTestCycleId() != null ? testCycleRequest.getTestCycleId() : (testCycleRequest.getTestCycle() == null ? null : testCycleRequest.getTestCycle().getId());
        MoveTestCycleRequestMarshaller.validateTestCycleId(testCycleId);
        ApiPreconditions.notNull(testCycleRequest.getArtifactLevel(), "Invalid artifact level passed to marshall(...)");
        MoveTestCycleRequestMarshaller.validateArtifactLevel(testCycleRequest.getArtifactLevel());
        MoveTestCycleRequestMarshaller.validateArtifact(testCycleRequest.getArtifactLevel(), testCycleRequest.getArtifactId());
        Request request = this.createJsonRequest(testCycleRequest, "MoveTestCycle", HttpMethod.PUT);
        StringBuilder builder = this.createApiPathBuilder(testCycleRequest.getProjectId());
        builder.append('/').append(testCycleId);
        request.setResourcePath(builder.toString());
        if (testCycleRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testCycleRequest.getArtifactId()));
        } else {
            request.addParameter("parentId", "0");
        }
        request.addParameter("parentType", testCycleRequest.getArtifactLevel().getQueryParam());
        if (testCycleRequest.getTestCycle() != null) {
            request.setContent(new StringInputStream(JsonMapper.toJson(testCycleRequest.getTestCycle())));
        }
        return request;
    }
}

