/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.plan.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.plan.model.CreateReleaseRequest;

public class CreateReleaseRequestMarshaller
extends AbstractMarshaller<Request, CreateReleaseRequest> {
    @Override
    protected void validateRequest(CreateReleaseRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid request passed to call(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project id passed to call(...)");
        }
        if (in.getRelease() == null) {
            throw new AuthClientException("Invalid release instance passed to call(...)");
        }
    }

    @Override
    protected void build(Request request, CreateReleaseRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return "TestPlanService";
    }

    @Override
    protected String getActionName() {
        return "CreateRelease";
    }

    @Override
    protected String getContent(CreateReleaseRequest in) throws Exception {
        return JsonMapper.toJson(in.getRelease());
    }

    @Override
    protected StringBuilder getResourcePath(CreateReleaseRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/releases");
    }
}

