/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.user;

import java.util.List;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.user.UserProfileService;
import org.qas.qtest.api.services.user.model.AssignToProjectRequest;
import org.qas.qtest.api.services.user.model.GetUserProfileRequest;
import org.qas.qtest.api.services.user.model.User;
import org.qas.qtest.api.services.user.model.UserProfile;
import org.qas.qtest.api.services.user.model.transform.BatchAssignUsersRequestMarshaller;
import org.qas.qtest.api.services.user.model.transform.GetUserProfileRequestMarshaller;
import org.qas.qtest.api.services.user.model.transform.ListUserJsonUnmarshaller;
import org.qas.qtest.api.services.user.model.transform.UserProfileJsonUnmarshaller;

public class UserProfileServiceClient
extends QTestApiWebServiceClient<UserProfileServiceClient>
implements UserProfileService {
    public UserProfileServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public UserProfileServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public UserProfileServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public UserProfileServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public UserProfileServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public UserProfileServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public UserProfile get(GetUserProfileRequest getUserProfileRequest) throws AuthServiceException {
        try {
            Object request = new GetUserProfileRequestMarshaller().marshall(getUserProfileRequest);
            return this.invoke((Request)request, UserProfileJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during get user profile from qTest service", ex);
        }
    }

    @Override
    public List<User> batchAssignUsers(AssignToProjectRequest assignToProjectRequest) throws AuthServiceException {
        try {
            Object request = new BatchAssignUsersRequestMarshaller().marshall(assignToProjectRequest);
            return this.invoke((Request)request, ListUserJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during assigning user to project", ex);
        }
    }
}

