/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.user;

import java.util.List;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.user.UserService;
import org.qas.qtest.api.services.user.model.AssignToProjectRequest;
import org.qas.qtest.api.services.user.model.AssignToProjectResult;
import org.qas.qtest.api.services.user.model.CreateUserRequest;
import org.qas.qtest.api.services.user.model.ListUserRequest;
import org.qas.qtest.api.services.user.model.User;
import org.qas.qtest.api.services.user.model.transform.AssignToProjectRequestMarshaller;
import org.qas.qtest.api.services.user.model.transform.AssignToProjectResultJsonUnmarshaller;
import org.qas.qtest.api.services.user.model.transform.CreateUserRequestMarshaller;
import org.qas.qtest.api.services.user.model.transform.ListUserJsonUnmarshaller;
import org.qas.qtest.api.services.user.model.transform.ListUserRequestMarshaller;
import org.qas.qtest.api.services.user.model.transform.UserJsonUnmarshaller;

public class UserServiceClient
extends QTestApiWebServiceClient<UserServiceClient>
implements UserService {
    public UserServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public UserServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public UserServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public UserServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public UserServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public UserServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public User create(CreateUserRequest createUserRequest) throws AuthServiceException {
        try {
            Object request = new CreateUserRequestMarshaller().marshall(createUserRequest);
            return this.invoke((Request)request, UserJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during create user to qTest service", ex);
        }
    }

    @Override
    public AssignToProjectResult assignToProject(AssignToProjectRequest assignToProjectRequest) throws AuthServiceException {
        try {
            Object request = new AssignToProjectRequestMarshaller().marshall(assignToProjectRequest);
            return this.invoke((Request)request, AssignToProjectResultJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during assigning user to project", ex);
        }
    }

    @Override
    public List<User> listUser(ListUserRequest listUserRequest) throws AuthServiceException {
        try {
            Object request = new ListUserRequestMarshaller().marshall(listUserRequest);
            return this.invoke((Request)request, ListUserJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during assigning user to project", ex);
        }
    }
}

