/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.dialog;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ExecutionProfileSelectionDialog
extends TreeEntitySelectionDialog {
    private List<Object> checkedItems;

    public ExecutionProfileSelectionDialog(Shell parent, IEntityLabelProvider labelProvider, ITreeContentProvider contentProvider, AbstractEntityViewerFilter entityViewerFilter) {
        super(parent, labelProvider, contentProvider, entityViewerFilter);
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.checkedItems = new ArrayList<Object>();
    }

    public TreeViewer createTreeViewer(Composite parent) {
        final ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                TreeItem item = (TreeItem)e.item;
                treeViewer.getTree().setSelection(item);
                ExecutionProfileSelectionDialog.this.onStateChangedTreeItem(item.getData(), item.getChecked());
            }
        });
        return treeViewer;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    private void onStateChangedTreeItem(Object element, boolean isChecked) {
        if (element instanceof ProfileTreeEntity) {
            if (isChecked) {
                this.checkedItems.add(element);
            } else {
                this.checkedItems.remove(element);
            }
            return;
        }
        if (element instanceof FolderTreeEntity) {
            try {
                ITreeEntity[] iTreeEntityArray = TreeEntityUtil.getChildren((FolderTreeEntity)((FolderTreeEntity)element));
                int n = iTreeEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeEntity childElement = iTreeEntityArray[n2];
                    this.onStateChangedTreeItem(childElement, isChecked);
                    ++n2;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    protected void computeResult() {
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        List<Object> grayedItems = Arrays.asList(treeViewer.getGrayedElements());
        this.checkedItems.removeAll(grayedItems);
        this.setResult(this.checkedItems);
    }

    public ProfileTreeEntity[] getSelectedProfiles() throws Exception {
        List<ProfileTreeEntity> selectedTreeEntities = this.flattenDialogResult(this.getResult());
        return selectedTreeEntities.toArray(new ProfileTreeEntity[selectedTreeEntities.size()]);
    }

    private List<ProfileTreeEntity> flattenDialogResult(Object[] dialogResult) throws Exception {
        if (dialogResult == null) {
            return Collections.emptyList();
        }
        ArrayList<ProfileTreeEntity> selectedTreeEntities = new ArrayList<ProfileTreeEntity>();
        Object[] objectArray = dialogResult;
        int n = dialogResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object eachResult = objectArray[n2];
            if (eachResult instanceof ProfileTreeEntity) {
                selectedTreeEntities.add((ProfileTreeEntity)eachResult);
            } else if (eachResult instanceof FolderTreeEntity) {
                selectedTreeEntities.addAll(this.flattenDialogResult(((FolderTreeEntity)eachResult).getChildren()));
            }
            ++n2;
        }
        return selectedTreeEntities;
    }
}

