/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.katalon.platform.api.exception.PlatformException;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.ExecutionProfileManager;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.ProblemMarkerConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.ProblemsViewDialog;
import com.kms.katalon.composer.execution.exceptions.JobCancelException;
import com.kms.katalon.composer.execution.jobs.ExecuteTestCaseJob;
import com.kms.katalon.composer.execution.launcher.IDELaunchShorcut;
import com.kms.katalon.composer.execution.launcher.IDELauncher;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteCompositePart;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.windows.driver.FlaUIDriverManager;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.FeatureFileExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExtensionRequiredException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.ExecutionProfileStore;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.ToolControlImpl;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractExecutionHandler {
    @Inject
    protected static EPartService partService;
    @Inject
    protected static EModelService modelService;
    @Inject
    protected static ECommandService commandService;
    @Inject
    protected static EHandlerService handlerService;
    @Inject
    protected static MApplication application;
    @Inject
    protected static IEventBroker eventBroker;
    @Inject
    protected IFeatureController featureController;
    @Inject
    protected IProductFeatureDialog productFeatureDialog;
    protected boolean isDebugLaunchMode;

    @Inject
    public void start() {
        eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    IDELaunchShorcut.cleanAllConfigurations();
                }
                catch (CoreException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        block4: {
            block6: {
                String partElementId;
                MPart part;
                block7: {
                    MPartStack composerStack;
                    block5: {
                        if (ProjectController.getInstance().getCurrentProject() == null) break block4;
                        composerStack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)application);
                        if (composerStack != null) break block5;
                        return false;
                    }
                    if (!composerStack.isVisible() || !(composerStack.getSelectedElement() instanceof MPart)) break block6;
                    part = (MPart)composerStack.getSelectedElement();
                    partElementId = part.getElementId();
                    if (!partElementId.startsWith("com.kms.katalon.composer.content.testcase") && !partElementId.startsWith("com.kms.katalon.composer.content.testsuite")) break block7;
                    return true;
                }
                try {
                    CompatibilityEditor editor;
                    if (!partElementId.startsWith("org.eclipse.e4.ui.compatibility.editor") || (editor = (CompatibilityEditor)part.getObject()) == null || !"cucumber.eclipse.editor.editors.Editor".equals(editor.getReference().getId())) break block6;
                    return true;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
            return false;
        }
        return false;
    }

    protected LaunchMode getLaunchMode(ParameterizedCommand command) {
        String launchModeAsString = ObjectUtils.toString(command.getParameterMap().get("com.kms.katalon.composer.execution.runMode"));
        LaunchMode launchMode = LaunchMode.fromText((String)launchModeAsString);
        this.isDebugLaunchMode = launchMode.isDebugLauchMode();
        return launchMode;
    }

    @Execute
    public void execute(ParameterizedCommand command) {
        try {
            LaunchMode launchMode = this.getLaunchMode(command);
            if (!this.checkExecutionEntitlement(launchMode)) {
                return;
            }
            this.execute(launchMode);
        }
        catch (ExecutionException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)e.getMessage());
        }
        catch (SWTException sWTException) {
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_TEST_SCRIPT_ROOT_CAUSE, e.getMessage()));
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static Entity getExecutionTarget() throws DALException {
        MPartStack composerStack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)application);
        MPart selectedPart = (MPart)composerStack.getSelectedElement();
        if (AbstractExecutionHandler.saveAllParts() && AbstractExecutionHandler.areAllPartsSaved()) {
            CompatibilityEditor editor;
            String partElementId = selectedPart.getElementId();
            if (partElementId.startsWith("com.kms.katalon.composer.content.testcase") && selectedPart.getObject() instanceof TestCaseCompositePart) {
                TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)selectedPart.getObject();
                try {
                    testCaseCompositePart.validateScriptErrors();
                }
                catch (Exception exception) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_ERROR_IN_SCRIPT);
                    return null;
                }
                if (testCaseCompositePart.isTestCaseEmpty()) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_TITLE_INFORMATION, (String)StringConstants.HAND_INFO_MSG_NO_TEST_STEP_IN_TEST_CASE);
                    return null;
                }
                return testCaseCompositePart.getOriginalTestCase();
            }
            if (partElementId.startsWith("com.kms.katalon.composer.content.testsuite") && selectedPart.getObject() instanceof ParentTestSuiteCompositePart) {
                ParentTestSuiteCompositePart testSuiteComposite = (ParentTestSuiteCompositePart)selectedPart.getObject();
                TestSuiteEntity originalTestSuite = testSuiteComposite.getOriginalTestSuite();
                if (originalTestSuite instanceof FilteringTestSuiteEntity) {
                    return originalTestSuite;
                }
                if (originalTestSuite.getTestSuiteTestCaseLinks().isEmpty()) {
                    if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_TITLE_INFORMATION, (String)StringConstants.HAND_CONFIRM_MSG_NO_TEST_CASE_IN_TEST_SUITE)) {
                        ((TestSuiteCompositePart)testSuiteComposite).openAddTestCaseDialog();
                    }
                    return null;
                }
                return originalTestSuite;
            }
            if (partElementId.startsWith("com.kms.katalon.composer.content.testsuite") && selectedPart.getObject() instanceof TestSuiteCompositePart) {
                TestSuiteCompositePart testSuiteComposite = (TestSuiteCompositePart)selectedPart.getObject();
                if (testSuiteComposite.getOriginalTestSuite().getTestSuiteTestCaseLinks().isEmpty()) {
                    if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_TITLE_INFORMATION, (String)StringConstants.HAND_CONFIRM_MSG_NO_TEST_CASE_IN_TEST_SUITE)) {
                        testSuiteComposite.openAddTestCaseDialog();
                    }
                    return null;
                }
                return testSuiteComposite.getOriginalTestSuite();
            }
            if (partElementId.startsWith("org.eclipse.e4.ui.compatibility.editor") && "cucumber.eclipse.editor.editors.Editor".equals((editor = (CompatibilityEditor)selectedPart.getObject()).getReference().getId())) {
                FileEditorInput editorInput = (FileEditorInput)editor.getEditor().getEditorInput();
                String featureFilePath = new File(editorInput.getFile().getRawLocationURI()).getAbsolutePath();
                try {
                    return SystemFileController.getInstance().getSystemFile(featureFilePath, ProjectController.getInstance().getCurrentProject());
                }
                catch (ControllerException e) {
                    LogUtil.logError((Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    protected static boolean areAllPartsSaved() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getDirtyEditors().length == 0 && partService.getDirtyParts().isEmpty();
    }

    protected static boolean saveAllParts() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false) && partService.saveAll(false);
    }

    protected abstract IRunConfiguration getRunConfigurationForExecution(String var1) throws IOException, ExecutionException, InterruptedException;

    private String getProjectDir() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation();
    }

    public AbstractRunConfiguration buildRunConfiguration(String projectDir) throws IOException, ExecutionException, InterruptedException {
        TestSuiteRunnable runnable = new TestSuiteRunnable();
        UISynchronizeService.syncExec((Runnable)runnable);
        return runnable.getRunConfiguration();
    }

    protected boolean checkExecutionEntitlement(LaunchMode launchMode) {
        if (launchMode == LaunchMode.DEBUG && !this.featureController.canUse(ProductFeature.DEBUG_MODE)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.DEBUG_MODE);
            return false;
        }
        return true;
    }

    protected void execute(LaunchMode launchMode) throws Exception {
        Entity targetEntity = AbstractExecutionHandler.getExecutionTarget();
        if (targetEntity == null) {
            return;
        }
        UISynchronizeService.syncExec(() -> this.safeProcessToRun(launchMode, targetEntity));
    }

    protected void safeProcessToRun(LaunchMode launchMode, Entity targetEntity) {
        block8: {
            try {
                IProject project = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject());
                List<IMarker> errorMarkers = ProblemMarkerConstants.findErrorMarkers(project);
                if (errorMarkers.size() != 0) {
                    ProblemsViewDialog dialog = new ProblemsViewDialog(Display.getCurrent().getActiveShell());
                    switch (dialog.open()) {
                        case 1: {
                            AbstractExecutionHandler.openProlemsView();
                            break block8;
                        }
                        case 10: {
                            this.settingDebugUI();
                            this.processToRun(launchMode, targetEntity);
                            break block8;
                        }
                        default: {
                            return;
                        }
                    }
                }
                this.processToRun(launchMode, targetEntity);
            }
            catch (SWTException sWTException) {
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_TEST_SCRIPT_ROOT_CAUSE, e.getMessage()));
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void processToRun(LaunchMode launchMode, Entity targetEntity) throws Exception {
        if (targetEntity instanceof TestCaseEntity) {
            TestCaseEntity testCase = (TestCaseEntity)targetEntity;
            this.executeTestCase(testCase, launchMode);
            eventBroker.post("EXECUTE/EXECUTE_TEST_CASE", null);
            return;
        }
        if (targetEntity instanceof TestSuiteEntity) {
            TestSuiteEntity testSuite = (TestSuiteEntity)targetEntity;
            this.executeTestSuite(testSuite, launchMode);
            eventBroker.post("EXECUTE/EXECUTE_TEST_SUITE", null);
            return;
        }
        if (targetEntity instanceof SystemFileEntity) {
            SystemFileEntity feature = (SystemFileEntity)targetEntity;
            this.executeFeatureFile(feature, launchMode);
            return;
        }
    }

    public void settingDebugUI() {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"org.eclipse.debug.ui");
        boolean isFirstTimeSetup = store.getBoolean("firstTimeSetupCompleted");
        if (isFirstTimeSetup) {
            return;
        }
        store.setValue("firstTimeSetupCompleted", true);
        store.setValue("org.eclipse.debug.ui.cancel_launch_with_compile_errors", "always");
        try {
            store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void executeFeatureFile(final SystemFileEntity feature, final LaunchMode launchMode) throws Exception {
        final Job job = new Job(ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_JOB_LAUNCHING_FEATURE_FILE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_JOB_LAUNCHING_FEATURE_FILE, 3);
                    FeatureFileExecutedEntity testSuiteExecutedEntity = new FeatureFileExecutedEntity(feature);
                    monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
                    AbstractExecutionHandler.openConsoleLog();
                    AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                    monitor.worked(1);
                    monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
                    AbstractRunConfiguration runConfig = AbstractExecutionHandler.this.buildRunConfiguration(AbstractExecutionHandler.this.getProjectDir());
                    if (runConfig == null) {
                        return Status.CANCEL_STATUS;
                    }
                    runConfig.build((FileEntity)feature, (IExecutedEntity)testSuiteExecutedEntity);
                    AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                    monitor.worked(1);
                    monitor.subTask(ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_JOB_LAUNCHING_FEATURE_FILE);
                    LauncherManager launcherManager = LauncherManager.getInstance();
                    IDELauncher launcher = new IDELauncher(launcherManager, (IRunConfiguration)runConfig, launchMode);
                    launcherManager.addLauncher((ILauncher)launcher);
                    monitor.worked(1);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (JobCancelException jobCancelException) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    UISynchronizeService.syncExec(() -> MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_MSG_UNABLE_TO_EXECUTE_FEATURE_FILE, (String)e.getMessage()));
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (!event.getResult().isOK()) {
                    FlaUIDriverManager.getInstance().stopLocalServer();
                }
                job.removeJobChangeListener((IJobChangeListener)this);
            }
        });
        eventBroker.subscribe("KATALON_EXECUTION/TEST_SUITE_FINISHED", new EventHandler(){

            public void handleEvent(Event event) {
                FlaUIDriverManager.getInstance().stopLocalServer();
                eventBroker.unsubscribe((EventHandler)this);
            }
        });
        job.schedule();
    }

    public void executeTestCase(TestCaseEntity testCase, LaunchMode launchMode) throws Exception {
        if (testCase == null) {
            return;
        }
        ExecuteTestCaseJob job = ExecuteTestCaseJob.newInstance(StringConstants.HAND_JOB_LAUNCHING_TEST_CASE, testCase, launchMode, UISynchronizeService.getInstance().getSync(), this);
        job.setUser(true);
        eventBroker.subscribe("EXECUTE/EXECUTE_TEST_CASE_ENDED", new EventHandler(){

            public void handleEvent(Event event) {
                FlaUIDriverManager.getInstance().stopLocalServer();
                eventBroker.unsubscribe((EventHandler)this);
            }
        });
        job.schedule();
    }

    public void executeTestSuite(final TestSuiteEntity testSuite, final LaunchMode launchMode) throws Exception {
        if (testSuite == null) {
            return;
        }
        final Job job = new Job(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE, 5);
                    monitor.subTask(StringConstants.HAND_JOB_VALIDATING_TEST_SUITE);
                    TestSuiteExecutedEntity testSuiteExecutedEntity = new TestSuiteExecutedEntity(testSuite);
                    monitor.subTask("Preparing test cases...");
                    testSuiteExecutedEntity.prepareTestCases();
                    boolean canUseDdtAtTcLevel = AbstractExecutionHandler.this.featureController.canUse(ProductFeature.TEST_CASE_DATA_BINDING);
                    if (testSuiteExecutedEntity.isUseDdtAtTCLevel() && !canUseDdtAtTcLevel) {
                        UISynchronizeService.syncExec(() -> AbstractExecutionHandler.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.TEST_CASE_DATA_BINDING));
                        monitor.done();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Map variables = EmailVariableBinding.getVariablesForTestSuiteEmailSettings((TestSuiteEntity)testSuite);
                    MailUtil.overrideEmailSettings((EmailConfig)testSuiteExecutedEntity.getEmailConfig(ProjectController.getInstance().getCurrentProject()), (ExecutionProfileEntity)ExecutionProfileStore.getInstance().getSelectedProfile(), (Map)variables);
                    int totalTestCases = testSuiteExecutedEntity.getTotalTestCases();
                    if (totalTestCases > 0) {
                        monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
                        AbstractExecutionHandler.openConsoleLog();
                        AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                        monitor.worked(1);
                        monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
                        AbstractRunConfiguration runConfig = AbstractExecutionHandler.this.buildRunConfiguration(AbstractExecutionHandler.this.getProjectDir());
                        if (runConfig == null) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        LauncherManager launcherManager = LauncherManager.getInstance();
                        runConfig.setDebugLaunchMode(launchMode.isDebugLauchMode());
                        runConfig.build((FileEntity)testSuite, (IExecutedEntity)testSuiteExecutedEntity);
                        AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                        monitor.worked(1);
                        monitor.subTask(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE);
                        IDELauncher launcher = new IDELauncher(launcherManager, (IRunConfiguration)runConfig, launchMode);
                        launcherManager.addLauncher((ILauncher)launcher);
                        monitor.worked(1);
                        monitor.done();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    UISynchronizeService.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_NO_TEST_CASE_SELECTED);
                        }
                    });
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (JobCancelException jobCancelException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (ExtensionRequiredException e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getMessage());
                    return status;
                }
                catch (PlatformException e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getDetailMessage(), (Throwable)e);
                    return status;
                }
                catch (Exception e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getMessage(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (event.getResult() != null && event.getResult().matches(2)) {
                    UISynchronizeService.asyncExec(() -> {
                        if (event.getResult().getException() == null) {
                            MessageDialog.openInformation(null, (String)StringConstants.WARN_TITLE, (String)event.getResult().getMessage());
                        } else {
                            MultiStatusErrorDialog.showErrorDialog((String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_SUITE, (String)event.getResult().getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)event.getResult().getException()));
                        }
                    });
                }
                if (!event.getResult().isOK()) {
                    FlaUIDriverManager.getInstance().stopLocalServer();
                }
                job.removeJobChangeListener((IJobChangeListener)this);
            }
        });
        eventBroker.subscribe("EXECUTE/EXECUTE_TEST_SUITE_ENDED", new EventHandler(){

            public void handleEvent(Event event) {
                FlaUIDriverManager.getInstance().stopLocalServer();
                eventBroker.unsubscribe((EventHandler)this);
            }
        });
        job.schedule();
    }

    public static void openConsoleLog() {
        IPreferenceStore debugUIPreferences = DebugUIPlugin.getDefault().getPreferenceStore();
        debugUIPreferences.setValue("DEBUG.consoleOpenOnErr", false);
        debugUIPreferences.setValue("DEBUG.consoleOpenOnOut", false);
        debugUIPreferences.setValue("org.eclipse.debug.ui.auto_remove_old_launches", false);
        UISynchronizeService.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolControlImpl toolControl;
                MPart consoleLogPart;
                List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
                MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
                consolePartStack.getTags().remove("Minimized");
                consolePartStack.setVisible(true);
                if (!consolePartStack.isToBeRendered()) {
                    consolePartStack.setToBeRendered(true);
                }
                if ((consoleLogPart = (MPart)modelService.find("com.kms.katalon.partstack.console.log", (MUIElement)consolePartStack)) != null && consolePartStack.getSelectedElement() != consoleLogPart) {
                    consolePartStack.setSelectedElement((MUIElement)consoleLogPart);
                }
                MPartStack rightPartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.outline", (MUIElement)application);
                MPart jobViewerPart = (MPart)modelService.find("com.kms.katalon.composer.execution.part.job", (MUIElement)rightPartStack);
                if (rightPartStack.getSelectedElement() != jobViewerPart) {
                    rightPartStack.setSelectedElement((MUIElement)jobViewerPart);
                }
                if ((toolControl = (ToolControlImpl)modelService.find("com.kms.katalon.partstack.outline(com.kms.katalon.composer.window.main).(com.kms.katalon.composer.perspective.keyword)", (MUIElement)application)).getObject() != null) {
                    TrimStack trimStack = (TrimStack)toolControl.getObject();
                    trimStack.showStack(true);
                }
            }
        });
    }

    public static void openProlemsView() {
        UISynchronizeService.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MUIElement consoleLogPart;
                List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
                MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
                consolePartStack.getTags().remove("Minimized");
                consolePartStack.setVisible(true);
                if (!consolePartStack.isToBeRendered()) {
                    consolePartStack.setToBeRendered(true);
                }
                if ((consoleLogPart = modelService.find("org.eclipse.ui.views.ProblemView", (MUIElement)consolePartStack)) != null && consolePartStack.getSelectedElement() != consoleLogPart) {
                    consolePartStack.setSelectedElement((MUIElement)((MStackElement)consoleLogPart));
                }
            }
        });
    }

    public UISynchronize getSync() {
        return UISynchronizeService.getInstance().getSync();
    }

    void validateJobProgressMonitor(IProgressMonitor monitor) throws JobCancelException {
        if (monitor.isCanceled()) {
            throw new JobCancelException();
        }
    }

    private class TestSuiteRunnable
    implements Runnable {
        private AbstractRunConfiguration runConfiguration;

        private TestSuiteRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runConfiguration = (AbstractRunConfiguration)AbstractExecutionHandler.this.getRunConfigurationForExecution(AbstractExecutionHandler.this.getProjectDir());
                if (this.runConfiguration == null) {
                    this.runConfiguration = null;
                    return;
                }
                this.runConfiguration.setExecutionProfile(ExecutionProfileManager.getInstance().getSelectedProfile());
            }
            catch (ExecutionException | IOException | InterruptedException throwable) {
                this.runConfiguration = null;
            }
        }

        public AbstractRunConfiguration getRunConfiguration() {
            if (this.runConfiguration != null) {
                this.runConfiguration.setDebugLaunchMode(AbstractExecutionHandler.this.isDebugLaunchMode);
            }
            RunConfiguration.getInstance().setLaunchingDebugMode(AbstractExecutionHandler.this.isDebugLaunchMode);
            return this.runConfiguration;
        }
    }
}

