/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.part;

import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.composer.execution.part.LauncherItem;
import com.kms.katalon.composer.execution.util.LauncherHelper;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class JobViewerPart
implements EventHandler {
    private Composite listCompositeLauncher;
    private Composite parentComposite;
    private ScrolledComposite scrolledComposite;
    private MPart mpart;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        this.parentComposite = parent;
        this.mpart = mpart;
        this.registerListeners();
        this.updateToolItemStatus();
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.scrolledComposite = new ScrolledComposite(this.parentComposite, 512);
        this.scrolledComposite.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.scrolledComposite.setBackgroundMode(2);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.listCompositeLauncher = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.listCompositeLauncher);
        GridLayout gl_composite_listLauncher = new GridLayout(1, false);
        gl_composite_listLauncher.marginHeight = 0;
        gl_composite_listLauncher.marginWidth = 0;
        this.listCompositeLauncher.setLayout((Layout)gl_composite_listLauncher);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = JobViewerPart.this.scrolledComposite.getClientArea();
                JobViewerPart.this.scrolledComposite.setMinSize(JobViewerPart.this.listCompositeLauncher.computeSize(r.width, -1));
            }
        });
        this.redrawAllLaunchers();
    }

    private void updateToolItemStatus() {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            for (MToolBarElement toolbarElement : this.mpart.getToolbar().getChildren()) {
                MDirectToolItem toolItem = (MDirectToolItem)toolbarElement;
                switch (toolItem.getElementId()) {
                    case "com.kms.katalon.composer.execution.directtoolitem.removeAllTerminated": {
                        toolItem.setEnabled(project != null && LauncherManager.getInstance().isAnyLauncherTerminated());
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void registerListeners() {
        this.eventBroker.subscribe("JOB/REFRESH", (EventHandler)this);
        this.eventBroker.subscribe("JOB/UPDATE_PROGRESS", (EventHandler)this);
    }

    private void createJobComposite(Composite parent, IDEObservableLauncher launcher) throws Exception {
        LauncherItem launcherItem = (LauncherItem)ComponentBuilder.from((Widget)new LauncherItem(parent, launcher)).build();
        ComponentEventUtil.onClick((Widget)launcherItem, event -> this.setSelectedLauncher(launcher.getId()), (boolean)true);
    }

    private void setSelectedLauncher(String launcherId) {
        this.setObservedLauncher(launcherId);
        this.notifyLauncherSelected(launcherId);
        this.updateAllLauncherItems();
    }

    private void setObservedLauncher(String launcherId) {
        LauncherHelper.setObservedLauncher(launcherId, LauncherManager.getInstance().getAllLaunchers());
    }

    private void notifyLauncherSelected(String launcherId) {
        try {
            this.eventBroker.send("CONSOLE_LOG/RESET", (Object)launcherId);
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void updateAllLauncherItems() {
        Control[] controlArray = this.listCompositeLauncher.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof LauncherItem) {
                LauncherItem launcherItem = (LauncherItem)child;
                launcherItem.sync();
            }
            ++n2;
        }
    }

    private void redrawAllLaunchers() {
        ComponentUtil.removeAllChildren((Composite)this.listCompositeLauncher);
        try {
            for (ILauncher launcher : LauncherManager.getInstance().getAllLaunchers()) {
                if (!(launcher instanceof IDEObservableLauncher)) continue;
                IDEObservableLauncher observableLauncher = (IDEObservableLauncher)launcher;
                this.createJobComposite(this.listCompositeLauncher, observableLauncher);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.listCompositeLauncher.setSize(this.listCompositeLauncher.computeSize(-1, -1));
        Rectangle r = this.scrolledComposite.getClientArea();
        this.scrolledComposite.setMinSize(this.listCompositeLauncher.computeSize(r.width, -1));
        this.updateToolItemStatus();
    }

    /*
     * WARNING - void declaration
     */
    private void handleJobRefreshEvent(Event event) {
        void launcherId;
        this.redrawAllLaunchers();
        Object object = EventUtil.getData((Event)event);
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        this.setObservedLauncher((String)launcherId);
        this.updateAllLauncherItems();
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(Event event) {
        try {
            if (event.getTopic().equals("JOB/REFRESH")) {
                this.handleJobRefreshEvent(event);
            } else if (event.getTopic().equals("JOB/UPDATE_PROGRESS")) {
                Object object = EventUtil.getData((Event)event);
                if (object == null || !(object instanceof String)) {
                    return;
                }
                String string = (String)object;
                Control[] controlArray = this.listCompositeLauncher.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    void launcherId;
                    LauncherItem launcherItem;
                    Control control = controlArray[n2];
                    if (control instanceof LauncherItem && StringUtils.equals((CharSequence)(launcherItem = (LauncherItem)control).getLauncherId(), (CharSequence)launcherId)) {
                        launcherItem.sync();
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

