/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.provider;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogTableViewer
extends TableViewer {
    private static final int DEPTH_OF_MAIN_TEST_CASE = 0;
    private List<XmlLogRecord> records;
    private int logDepth;
    private IEventBroker eventBroker;
    private ScopedPreferenceStore store;
    private LogRecord latestResultRecord;

    public LogTableViewer(Composite parent, int style, IEventBroker eventBroker) {
        super(parent, style);
        this.eventBroker = eventBroker;
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.store = PreferenceStoreManager.getPreferenceStore(LogTableViewer.class);
        this.clearAll();
    }

    public void clearAll() {
        this.records = new ArrayList<XmlLogRecord>();
        super.setInput(this.records);
        this.logDepth = 0;
        this.latestResultRecord = null;
    }

    public void add(Object object) {
        if (object != null && object instanceof XmlLogRecord) {
            XmlLogRecord record = (XmlLogRecord)object;
            this.records.add(record);
            super.add((Object)record);
            LogLevel logLevel = LogLevel.valueOf((Level)record.getLevel());
            switch (logLevel) {
                case END: {
                    --this.logDepth;
                    if (!"endTest".equals(record.getSourceMethodName())) break;
                    this.eventBroker.send("CONSOLE_LOG/UPDATE_PROGRESS_BAR", (Object)this.latestResultRecord);
                    break;
                }
                case START: {
                    String startName = record.getSourceMethodName();
                    if ("startSuite".equals(startName)) break;
                    ++this.logDepth;
                    break;
                }
                default: {
                    if (!LogLevel.getResultLogs().contains(logLevel) || this.logDepth != 1) break;
                    this.latestResultRecord = record;
                }
            }
            this.updateTableBackgroundColor();
        }
    }

    public void refresh() {
        super.refresh();
        super.setInput(this.records);
        this.updateTableBackgroundColor();
    }

    private void updateTableBackgroundColor() {
        int lastItemIndex;
        Table table = this.getTable();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            XmlLogRecord record = (XmlLogRecord)item.getData();
            LogLevel logLevel = LogLevel.valueOf((Level)record.getLevel());
            if (logLevel != null) {
                switch (logLevel) {
                    case PASSED: {
                        item.setBackground(ColorUtil.getPassedLogBackgroundColor());
                        item.setForeground(Display.getCurrent().getSystemColor(2));
                        break;
                    }
                    case FAILED: {
                        item.setBackground(ColorUtil.getFailedLogBackgroundColor());
                        item.setForeground(Display.getCurrent().getSystemColor(1));
                        break;
                    }
                    case ERROR: {
                        item.setBackground(ColorUtil.getErrorLogBackgroundColor());
                        item.setForeground(Display.getCurrent().getSystemColor(2));
                        break;
                    }
                    case WARNING: {
                        item.setBackground(ColorUtil.getWarningLogBackgroundColor());
                        item.setForeground(Display.getCurrent().getSystemColor(2));
                        break;
                    }
                    case NOT_RUN: {
                        item.setBackground(ColorUtil.getDisabledItemBackgroundColor());
                        item.setForeground(Display.getCurrent().getSystemColor(2));
                        break;
                    }
                }
            }
            ++n2;
        }
        if (this.isScrollLogEnable() && (lastItemIndex = table.getItemCount() - 1) >= 0) {
            table.showItem(table.getItem(lastItemIndex));
        }
    }

    private boolean isScrollLogEnable() {
        return !this.store.getBoolean("log.pinView");
    }

    public List<XmlLogRecord> getRecords() {
        return this.records;
    }
}

