/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.provider;

import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class LogViewerFilter
extends ViewerFilter {
    public static final int ALL = 1;
    public static final int INFO = 2;
    public static final int PASSED = 4;
    public static final int FAILED = 8;
    public static final int ERROR = 16;
    public static final int WARNING = 32;
    public static final int NOT_RUN = 64;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        XmlLogRecord record = (XmlLogRecord)element;
        return (this.evaluteLog(record) & this.getPreferenceShowedValue()) != 0;
    }

    protected int getPreferenceShowedValue() {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(LogViewerFilter.class);
        int showAllLogs = store.getBoolean("log.showAll") ? 1 : 0;
        int showInfoLogs = store.getBoolean("log.showInfo") ? 2 : 0;
        int showPassedLogs = store.getBoolean("log.showPasses") ? 4 : 0;
        int showFailedLogs = store.getBoolean("log.showFailures") ? 8 : 0;
        int showIncompleteLogs = store.getBoolean("log.showErrors") ? 16 : 0;
        int showWarningLogs = store.getBoolean("log.showWarning") ? 32 : 0;
        int showNotRunLogs = store.getBoolean("log.showNotRun") ? 64 : 0;
        return showAllLogs & 1 | showInfoLogs & 2 | showPassedLogs & 4 | showFailedLogs & 8 | showIncompleteLogs & 0x10 | showWarningLogs & 0x20 | showNotRunLogs & 0x40;
    }

    protected int evaluteLog(XmlLogRecord record) {
        int value = 1;
        if (record == null) {
            return value;
        }
        LogLevel level = LogLevel.valueOf((String)record.getLevel().getName());
        if (level == LogLevel.INFO) {
            value |= 2;
        } else if (level == LogLevel.PASSED) {
            value |= 4;
        } else if (level == LogLevel.FAILED) {
            value |= 8;
        } else if (level == LogLevel.ERROR) {
            value |= 0x10;
        } else if (level == LogLevel.WARNING) {
            value |= 0x20;
        } else if (level == LogLevel.NOT_RUN) {
            value |= 0x40;
        }
        return value;
    }
}

