/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.trace;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.execution.trace.StyleRangeMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyleRange;

public abstract class ArtifactStyleRangeMatcher
implements StyleRangeMatcher {
    public abstract String getPattern();

    @Override
    public List<StyleRange> getStyleRanges(String message) {
        if (StringUtils.isEmpty((String)message)) {
            return Collections.emptyList();
        }
        Matcher matcher = Pattern.compile(this.getPattern()).matcher(message);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        while (matcher.find()) {
            StyleRange range = new StyleRange();
            range.start = matcher.start() + 1;
            range.length = matcher.end() - matcher.start() - 2;
            range.underline = true;
            range.foreground = ColorUtil.getHyperlinkTextColor();
            range.underlineStyle = 4;
            range.data = this;
            styleRanges.add(range);
        }
        return styleRanges;
    }

    @Override
    public void onClick(String message, StyleRange styleRange) {
        String artifactId = message.substring(styleRange.start, styleRange.length + styleRange.start);
        this.internalClick(artifactId);
    }

    protected void internalClick(String artifactId) {
    }
}

