/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.UserFileTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.dialogs.RenameUserFileEntityDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.UserFileController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.UserFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameUserFileEntityHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof UserFileTreeEntity) {
                    RenameUserFileEntityHandler.this.execute((UserFileTreeEntity)object);
                }
            }
        });
    }

    private void execute(UserFileTreeEntity userFileTreeEntity) {
        try {
            List<String> existingFileNames;
            boolean isRoot;
            UserFileController userFileController = UserFileController.getInstance();
            FolderTreeEntity parentTreeFolder = (FolderTreeEntity)userFileTreeEntity.getParent();
            UserFileEntity userFileEntity = (UserFileEntity)userFileTreeEntity.getObject();
            boolean bl = isRoot = parentTreeFolder == null;
            if (isRoot) {
                ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                existingFileNames = FolderController.getInstance().getRootFileOrFolderNames(project);
            } else {
                FolderEntity parentFolder = parentTreeFolder.getObject();
                existingFileNames = userFileController.getSiblingFiles(userFileEntity, parentFolder).stream().map(f -> f.toFile().getName()).collect(Collectors.toList());
            }
            RenameUserFileEntityDialog dialog = new RenameUserFileEntityDialog(this.parentShell, (FileEntity)userFileEntity, existingFileNames);
            if (dialog.open() == 0) {
                String newName = dialog.getNewFileName();
                String oldName = userFileEntity.getName();
                if (!StringUtils.isBlank((String)newName) && !newName.equals(oldName)) {
                    UserFileEntity newFileEntity = UserFileController.getInstance().renameFile(newName, userFileEntity);
                    userFileTreeEntity.setObject((Object)newFileEntity);
                    this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)userFileTreeEntity);
                    this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)userFileTreeEntity);
                }
            }
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to rename file", (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

