/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.lightbody.bmp.proxy.dns.AbstractHostNameRemapper;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeResolver
extends AbstractHostNameRemapper
implements AdvancedHostResolver {
    private static final Logger log = LoggerFactory.getLogger(NativeResolver.class);

    @Override
    public void clearDNSCache() {
        log.debug("Cannot clear native JVM DNS Cache using this Resolver");
    }

    @Override
    public void setPositiveDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        log.debug("Cannot change native JVM DNS cache timeout using this Resolver");
    }

    @Override
    public void setNegativeDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        log.debug("Cannot change native JVM DNS cache timeout using this Resolver");
    }

    @Override
    public Collection<InetAddress> resolveRemapped(String remappedHost) {
        try {
            List<InetAddress> addresses = Arrays.asList(InetAddress.getAllByName(remappedHost));
            return addresses;
        }
        catch (UnknownHostException unknownHostException) {
            return Collections.emptyList();
        }
    }
}

