/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import net.lightbody.bmp.util.HttpObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageContents {
    private static final Logger log = LoggerFactory.getLogger(HttpMessageContents.class);
    private final FullHttpMessage httpMessage;
    private volatile String textContents;
    private volatile byte[] binaryContents;

    public HttpMessageContents(FullHttpMessage httpMessage) {
        this.httpMessage = httpMessage;
    }

    public void setTextContents(String newContents) {
        HttpObjectUtil.replaceTextHttpEntityBody(this.httpMessage, newContents);
        this.textContents = null;
        this.binaryContents = null;
    }

    public void setBinaryContents(byte[] newBinaryContents) {
        HttpObjectUtil.replaceBinaryHttpEntityBody(this.httpMessage, newBinaryContents);
        this.binaryContents = null;
        this.textContents = null;
    }

    public String getTextContents() throws UnsupportedCharsetException {
        if (this.textContents == null) {
            this.textContents = HttpObjectUtil.extractHttpEntityBody(this.httpMessage);
        }
        return this.textContents;
    }

    public byte[] getBinaryContents() {
        if (this.binaryContents == null) {
            this.binaryContents = HttpObjectUtil.extractBinaryHttpEntityBody((HttpContent)this.httpMessage);
        }
        return this.binaryContents;
    }

    public String getContentType() {
        String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)this.httpMessage, (String)"Content-Type");
        if (contentTypeHeader == null || contentTypeHeader.isEmpty()) {
            return "application/octet-stream";
        }
        return contentTypeHeader;
    }

    public Charset getCharset() throws UnsupportedCharsetException {
        String contentTypeHeader = this.getContentType();
        Charset charset = null;
        try {
            charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader(contentTypeHeader);
        }
        catch (net.lightbody.bmp.exception.UnsupportedCharsetException e) {
            UnsupportedCharsetException cause = e.getUnsupportedCharsetExceptionCause();
            log.error("Character set specified in Content-Type header is not supported on this platform. Content-Type header: {}", (Object)contentTypeHeader, (Object)cause);
            throw cause;
        }
        if (charset == null) {
            return BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
        }
        return charset;
    }

    public boolean isText() {
        return BrowserMobHttpUtil.hasTextualContent(this.getContentType());
    }
}

