/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpObjectUtil.class);

    public static void replaceTextHttpEntityBody(FullHttpMessage message, String newContents) {
        Charset messageCharset;
        String contentTypeHeader = message.headers().get("Content-Type");
        try {
            messageCharset = BrowserMobHttpUtil.readCharsetInContentTypeHeader(contentTypeHeader);
        }
        catch (net.lightbody.bmp.exception.UnsupportedCharsetException e) {
            UnsupportedCharsetException cause = e.getUnsupportedCharsetExceptionCause();
            log.error("Found unsupported character set in Content-Type header '{}' while attempting to replace contents of HTTP message.", (Object)contentTypeHeader, (Object)cause);
            throw cause;
        }
        if (messageCharset == null) {
            messageCharset = BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
            log.warn("No character set declared in HTTP message. Replacing text using default charset {}.", (Object)messageCharset);
        }
        byte[] contentBytes = newContents.getBytes(messageCharset);
        HttpObjectUtil.replaceBinaryHttpEntityBody(message, contentBytes);
    }

    public static void replaceBinaryHttpEntityBody(FullHttpMessage message, byte[] newBinaryContents) {
        message.content().resetWriterIndex();
        message.content().ensureWritable(newBinaryContents.length, true);
        message.content().writeBytes(newBinaryContents);
        message.headers().set("Content-Length", (Object)newBinaryContents.length);
    }

    public static String extractHttpEntityBody(HttpContent httpContent, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("No charset specified when extracting the contents of an HTTP message");
        }
        byte[] contentBytes = BrowserMobHttpUtil.extractReadableBytes(httpContent.content());
        return new String(contentBytes, charset);
    }

    public static String extractHttpEntityBody(FullHttpMessage httpMessage) {
        Charset charset;
        try {
            charset = HttpObjectUtil.getCharsetFromMessage((HttpMessage)httpMessage);
        }
        catch (net.lightbody.bmp.exception.UnsupportedCharsetException e) {
            UnsupportedCharsetException cause = e.getUnsupportedCharsetExceptionCause();
            String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)httpMessage, (String)"Content-Type");
            log.error("Cannot retrieve text contents of message because HTTP message declares a character set that is not supported on this platform. Content type header: {}.", (Object)contentTypeHeader, (Object)cause);
            throw cause;
        }
        return HttpObjectUtil.extractHttpEntityBody((HttpContent)httpMessage, charset);
    }

    public static Charset getCharsetFromMessage(HttpMessage httpMessage) throws net.lightbody.bmp.exception.UnsupportedCharsetException {
        String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)httpMessage, (String)"Content-Type");
        Charset charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader(contentTypeHeader);
        if (charset == null) {
            return BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
        }
        return charset;
    }

    public static byte[] extractBinaryHttpEntityBody(HttpContent httpContent) {
        return BrowserMobHttpUtil.extractReadableBytes(httpContent.content());
    }
}

