/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.auth;

import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;

public class JaasSetupService {
    private static String PROP_KEY_USE_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static String PROP_KEY_LOGIN_CONFIG_PATH = "java.security.auth.login.config";
    private static String PROP_KEY_KATALON_KERBEROS_ENABLED = "katalon.kerberosEnabled";
    private static String ENV_KEY_KATALON_KERBEROS_ENABLED = "KATALON_KERBEROS_ENABLED";
    private boolean kerberosSupported = false;
    public static final JaasSetupService singleton = new JaasSetupService();

    public static JaasSetupService getInstance() {
        return singleton;
    }

    private JaasSetupService() {
    }

    public boolean isKerberosSupported() {
        return this.kerberosSupported;
    }

    public void enableKerberosIfSupported() {
        if (PlatformUtil.getCurrentPlattform() != PlatformUtil.Platform.WIN) {
            return;
        }
        if (!Boolean.valueOf(System.getProperty(PROP_KEY_KATALON_KERBEROS_ENABLED)).booleanValue() && !Boolean.valueOf(System.getenv(ENV_KEY_KATALON_KERBEROS_ENABLED)).booleanValue()) {
            return;
        }
        try {
            this.enableKerberos();
            this.kerberosSupported = true;
            LogUtil.logInfo((String)"Already enabled Kerberos support");
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to enable Kerberos support.");
        }
    }

    private void enableKerberos() throws IOException {
        String loginConfPath = Platform.getInstallLocation().getURL().getPath() + "login.conf";
        this.createLoginConfFileIfNonExistent(loginConfPath);
        if (Objects.isNull(System.getProperty(PROP_KEY_LOGIN_CONFIG_PATH))) {
            System.setProperty(PROP_KEY_LOGIN_CONFIG_PATH, loginConfPath);
        }
        if (Objects.isNull(System.getProperty(PROP_KEY_USE_SUBJECT_CREDS_ONLY))) {
            System.setProperty(PROP_KEY_USE_SUBJECT_CREDS_ONLY, "false");
        }
    }

    private void createLoginConfFileIfNonExistent(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        LogUtil.logInfo((String)String.format("Jass config file is non-existent at %s. Will create one.", path));
        String content = "com.sun.security.jgss.initiate  {\n    com.sun.security.auth.module.Krb5LoginModule required\n    client=TRUE useTicketCache=true\n    doNotPrompt=true storeKey=false\n    isInitiator=true\n    useKeyTab=false\n    renewTGT=false debug=true;\n};\n";
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.US_ASCII);
    }
}

