/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.db;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.exception.DriverNotFoundException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testdata.TestDataInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;

public class DatabaseConnection {
    private final KeywordLogger logger = KeywordLogger.getInstance(DatabaseConnection.class);
    private static final String PW_PROPERTY = "password";
    private static final String USER_PROPERTY = "user";
    private String connectionUrl;
    private Connection connection;
    private String user;
    private String password;
    private String driverClassName;
    private TestDataInfo dbDataInfo;
    private Properties properties;

    public DatabaseConnection(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        this.properties = new Properties();
    }

    public DatabaseConnection(String connectionUrl, String driverClassName) {
        this.connectionUrl = connectionUrl;
        this.driverClassName = driverClassName;
        this.properties = new Properties();
    }

    public DatabaseConnection(String connectionUrl, String user, String password) {
        this(connectionUrl);
        this.user = user;
        this.password = password;
    }

    public DatabaseConnection(String connectionUrl, String user, String password, String driverClassName) {
        this(connectionUrl);
        this.user = user;
        this.password = password;
        this.driverClassName = driverClassName;
    }

    public String getUserName() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null) {
            this.properties.setProperty(USER_PROPERTY, this.user);
        }
        if (this.password != null) {
            this.properties.setProperty(PW_PROPERTY, this.password);
        }
        return this.getConnection(this.properties);
    }

    private Connection getConnection(Properties properties) throws SQLException {
        if (this.isAlive()) {
            return this.connection;
        }
        String loadedDriverClassName = this.loadSuitableDatabaseDriver();
        if (StringUtils.isNotEmpty((CharSequence)loadedDriverClassName)) {
            try {
                this.connection = ((Driver)Class.forName(loadedDriverClassName, true, Thread.currentThread().getContextClassLoader()).newInstance()).connect(this.connectionUrl, properties);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                this.connection = DriverManager.getConnection(this.connectionUrl, properties);
            }
        } else {
            this.connection = DriverManager.getConnection(this.connectionUrl, properties);
        }
        try {
            this.connection.setAutoCommit(false);
        }
        catch (Throwable throwable) {}
        this.connection.setReadOnly(true);
        this.logNewConnection();
        return this.connection;
    }

    private void logNewConnection() {
        this.dbDataInfo = DatabaseConnection.newDBDataInfo(this.connection);
        this.logger.logRunData(this.dbDataInfo.getKey(), this.dbDataInfo.getInfo());
    }

    private String loadSuitableDatabaseDriver() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.driverClassName)) {
                if (this.driverClassName.equals("com.mysql.cj.jdbc.Driver") && StringUtils.startsWith((CharSequence)this.connectionUrl, (CharSequence)"jdbc:mysql")) {
                    try {
                        return this.loadDriverIntoClassPath("com.mysql.cj.jdbc.Driver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new DriverNotFoundException(MessageFormat.format(StringConstants.KRE_MSG_DRIVER_NOT_FOUND, this.connectionUrl));
                    }
                }
                Class.forName(this.driverClassName, true, Thread.currentThread().getContextClassLoader());
                return this.driverClassName;
            }
            if (StringUtils.startsWith((CharSequence)this.connectionUrl, (CharSequence)"jdbc:mysql")) {
                try {
                    return this.loadDriverIntoClassPath("com.mysql.cj.jdbc.Driver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DriverNotFoundException(MessageFormat.format(StringConstants.KRE_MSG_DRIVER_NOT_FOUND, this.connectionUrl));
                }
            }
            if (StringUtils.startsWith((CharSequence)this.connectionUrl, (CharSequence)"jdbc:sqlserver")) {
                return this.loadDriverIntoClassPath("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            }
            if (StringUtils.startsWith((CharSequence)this.connectionUrl, (CharSequence)"jdbc:oracle")) {
                return this.loadDriverIntoClassPath("oracle.jdbc.OracleDriver");
            }
            if (StringUtils.startsWith((CharSequence)this.connectionUrl, (CharSequence)"jdbc:postgresql")) {
                return this.loadDriverIntoClassPath("org.postgresql.Driver");
            }
            if (StringUtils.startsWith((CharSequence)this.connectionUrl, (CharSequence)"jdbc:databricks")) {
                return this.loadDriverIntoClassPath("com.simba.spark.jdbc.Driver");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return "";
    }

    private String loadDriverIntoClassPath(String driverName) throws ClassNotFoundException {
        Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        return driverName;
    }

    public boolean isAlive() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public void close() {
        DbUtils.closeQuietly((Connection)this.connection);
    }

    public TestDataInfo getDBDataInfo() {
        return this.dbDataInfo;
    }

    public static TestDataInfo newDBDataInfo(Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            DatabaseMetaData connectionMetaData = connection.getMetaData();
            return new TestDataInfo("dbServerInfo", connectionMetaData.getDatabaseProductName() + " " + connectionMetaData.getDatabaseProductVersion());
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.properties = connectionProperties;
    }

    public Properties getConnectionProperties() {
        return this.properties;
    }
}

