/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.db;

import com.kms.katalon.core.db.ConnectionProperty;
import com.kms.katalon.core.db.DBConnectionProperties;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class DatabaseSettings {
    public static final String URL = "URL";
    public static final String SECURE_USER_ACCOUNT = "SECURE_USER_ACCOUNT";
    public static final String USER = "USER";
    public static final String PW = "PASSWORD";
    public static final String DRIVERCLASSNAME = "DRIVERCLASSNAME";
    public static final String SHOW_WARNING = "SHOW_WARNING";
    public static final String CONNECTION_PROPERTIES = "CONNECTION_PROPERTIES";
    private Properties settings;

    public DatabaseSettings(String projectDirLocation) throws IOException {
        this.setSettings(PropertySettingStoreUtil.getExternalSettings(projectDirLocation, DatabaseSettings.class.getName()));
    }

    public DatabaseConnection getDatabaseConnection() {
        String url = this.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        String user = this.isSecureUserAccount() ? this.getUser() : null;
        String password = this.isSecureUserAccount() ? this.getPassword() : null;
        DatabaseConnection databaseConnection = new DatabaseConnection(url, user, password, this.getDriverClassName());
        Properties properties = this.convertListToProperties(this.getConnectionProperties());
        databaseConnection.setConnectionProperties(properties);
        return databaseConnection;
    }

    public void setSettings(Properties settings) {
        if (settings == null) {
            settings = new Properties();
        }
        this.settings = settings;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public String getUrl() {
        return this.settings.getProperty(URL);
    }

    public String getDriverClassName() {
        return this.settings.getProperty(DRIVERCLASSNAME);
    }

    public void setUrl(String url) {
        this.settings.setProperty(URL, StringUtils.trimToEmpty((String)url));
    }

    public void setDriverClassName(String driverClassName) {
        this.settings.setProperty(DRIVERCLASSNAME, StringUtils.trimToEmpty((String)driverClassName));
    }

    public boolean isSecureUserAccount() {
        return Boolean.parseBoolean(this.settings.getProperty(SECURE_USER_ACCOUNT));
    }

    public void setSecureUserAccount(boolean isSecureUserAccount) {
        this.settings.setProperty(SECURE_USER_ACCOUNT, String.valueOf(isSecureUserAccount));
    }

    public String getUser() {
        return this.settings.getProperty(USER);
    }

    public void setUser(String user) {
        this.settings.setProperty(USER, StringUtils.trimToEmpty((String)user));
    }

    public String getPassword() {
        return Base64.decode(this.settings.getProperty(PW));
    }

    public void setPassword(String plainTextPassword) {
        this.settings.setProperty(PW, Base64.encode(StringUtils.trimToEmpty((String)plainTextPassword)));
    }

    public boolean shouldShowWarning() {
        return this.settings.getProperty(SHOW_WARNING) == null;
    }

    public void setShowWarning(boolean showWarning) {
        this.settings.setProperty(SHOW_WARNING, String.valueOf(showWarning));
    }

    public List<ConnectionProperty> getConnectionProperties() {
        String json = this.settings.getProperty(CONNECTION_PROPERTIES);
        DBConnectionProperties props = JsonUtil.fromJson(json, DBConnectionProperties.class);
        if (props == null) {
            return new ArrayList<ConnectionProperty>();
        }
        return props.getConnectionProperty();
    }

    public void setConnectionProperties(List<ConnectionProperty> listProps) {
        DBConnectionProperties props = new DBConnectionProperties(listProps);
        String json = JsonUtil.toJson(props);
        this.settings.setProperty(CONNECTION_PROPERTIES, json);
    }

    private Properties convertListToProperties(List<ConnectionProperty> listProps) {
        Properties properties = new Properties();
        for (ConnectionProperty prop : this.getConnectionProperties()) {
            properties.put(prop.getName(), prop.getValue());
        }
        return properties;
    }
}

