/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import java.io.File;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class MessageLogRecord
extends AbstractLogRecord {
    private TestStatus testStatus;
    private String attachment;
    private String videoAttachment;

    public MessageLogRecord() {
        super("");
        this.setType("MESSAGE");
        this.videoAttachment = "";
    }

    public String getVideoAttachment() {
        return this.videoAttachment;
    }

    public void setVideoAttachment(String videoAttachment) {
        this.videoAttachment = videoAttachment;
    }

    public void setStatus(TestStatus testStatus) {
        this.testStatus = testStatus;
    }

    @Override
    public TestStatus getStatus() {
        return this.testStatus;
    }

    public String getAttachment() {
        return this.getAttachment(false);
    }

    public String getAttachment(boolean isInAbsolutePath) {
        if (!isInAbsolutePath || StringUtils.isBlank((String)this.attachment)) {
            return this.attachment;
        }
        String logFolder = this.getLogFolder();
        if (!this.attachment.contains(StringEscapeUtils.escapeJava((String)logFolder))) {
            if (this.attachment.contains(File.separator)) {
                return this.attachment;
            }
            return StringEscapeUtils.escapeJava((String)(logFolder + File.separator + this.attachment));
        }
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    @Override
    public String getJUnitMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getJUnitMessage());
        String attachmentFile = this.getAttachment(true);
        if (StringUtils.isNotBlank((String)attachmentFile)) {
            sb.append("[[ATTACHMENT|" + attachmentFile + "]]");
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String getLogFolder() {
        TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)this.getParentLogRecordByType(this.getParentLogRecord(), "TEST_SUITE");
        if (testSuiteLogRecord != null) {
            return testSuiteLogRecord.getLogFolder();
        }
        return "";
    }
}

