/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.main.CustomKeywordDelegatingMetaClass;
import com.kms.katalon.core.main.RawTestBindingScriptExecutor;
import com.kms.katalon.core.main.RawTestScriptExecutor;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseBindingExecutor;
import com.kms.katalon.core.main.TestCaseExecutor;
import com.kms.katalon.core.main.TestResult;
import com.kms.katalon.core.main.TestSuiteExecutor;
import com.kms.katalon.core.main.WSVerificationExecutor;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.logging.LogConfigurator;
import com.kms.katalon.util.CryptoUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.xml.XmlParser;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseMain {
    private static Logger logger = LoggerFactory.getLogger(TestCaseMain.class);
    private static final int DELAY_TIME = 50;
    private static ScriptEngine engine;
    private static ExecutionEventManager eventManager;
    private static Map<String, Object> secureVariables;

    public static void beforeStart() throws IOException {
        String defaultLogConfigPath = RunConfiguration.getLogbackConfigFileLocation();
        File defaultLogConfigFile = StringUtils.isNotEmpty((CharSequence)defaultLogConfigPath) ? new File(defaultLogConfigPath) : LogConfigurator.getConfigFile((String)"logback-execution.xml");
        LogConfigurator.initialize((File)defaultLogConfigFile, (File)TestCaseMain.findLogPropertyFile());
        GroovyClassLoader classLoader = new GroovyClassLoader(TestCaseMain.class.getClassLoader());
        engine = ScriptEngine.getDefault((ClassLoader)classLoader);
        TestCaseMain.loadInternalGlobalVariableClass(classLoader);
        TestCaseMain.loadCustomKeywordsClass(classLoader);
        TestCaseMain.modifyCustomKeywordsClassAtRunTime(classLoader);
        eventManager = ExecutionEventManager.getInstance();
    }

    private static void loadCustomKeywordsClass(GroovyClassLoader cl) {
        Class clazz = cl.parseClass("class CustomKeywords { }");
        InvokerHelper.metaRegistry.setMetaClass(clazz, (MetaClass)new CustomKeywordDelegatingMetaClass(clazz, cl));
    }

    private static void loadInternalGlobalVariableClass(GroovyClassLoader cl) {
        try {
            cl.loadClass("internal.GlobalVariable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                cl.parseClass(new File(RunConfiguration.getProjectDir(), StringConstants.INTERNAL_GLOBAL_VARIABLE_FILE_NAME));
            }
            catch (IOException | CompilationFailedException throwable) {}
        }
    }

    private static void modifyCustomKeywordsClassAtRunTime(GroovyClassLoader cl) {
        try {
            boolean isModified = false;
            ClassPool pool = ClassPool.getDefault();
            CtClass newCustomKeywordsClass = pool.get("CustomKeywords");
            if (newCustomKeywordsClass != null) {
                CtMethod[] methods;
                newCustomKeywordsClass.defrost();
                CtMethod[] ctMethodArray = methods = newCustomKeywordsClass.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    CtMethod method = ctMethodArray[n2];
                    if (method.getName().contains(".")) {
                        newCustomKeywordsClass.removeMethod(method);
                        isModified = true;
                    }
                    ++n2;
                }
                if (isModified) {
                    String path = RunConfiguration.getProjectDir() + File.separator + GlobalStringConstants.SYSTEM_FOLDER_NAME_BIN + File.separator + "lib";
                    newCustomKeywordsClass.writeFile(path);
                }
                Class<?> clazz = Class.forName("CustomKeywords");
                InvokerHelper.metaRegistry.setMetaClass(clazz, (MetaClass)new CustomKeywordDelegatingMetaClass(clazz, cl));
            }
        }
        catch (Exception exception) {}
    }

    public static TestResult runTestCase(String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl) throws InterruptedException {
        return TestCaseMain.runTestCase(testCaseId, testCaseBinding, flowControl, true, true);
    }

    public static TestResult runTestCase(String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        return TestCaseMain.runTestCase(testCaseId, testCaseBinding, flowControl, true, doCleanUp);
    }

    public static TestResult runTestCase(String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl, boolean isMain, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        String bindedValue = testCaseBinding.getBindedValues() == null ? "" : testCaseBinding.getBindedValues().getOrDefault(testCaseBinding.getIterationVariableName(), "");
        String getIterationVariableValue = Objects.toString(bindedValue);
        InternalTestCaseContext testCaseContext = new InternalTestCaseContext(testCaseId, getIterationVariableValue);
        testCaseContext.setMainTestCase(isMain);
        return new TestCaseExecutor(testCaseBinding, engine, eventManager, testCaseContext, doCleanUp).execute(flowControl);
    }

    public static TestResult runWSVerificationScript(String verificationScript, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        if (StringUtils.isBlank((CharSequence)verificationScript)) {
            return TestResult.getDefault();
        }
        Thread.sleep(50L);
        return new WSVerificationExecutor(verificationScript, engine, eventManager, doCleanUp).execute(flowControl);
    }

    public static TestResult runWSVerificationScript(TestCaseBinding testCaseBinding, String verificationScript, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        if (StringUtils.isBlank((CharSequence)verificationScript)) {
            return TestResult.getDefault();
        }
        Thread.sleep(50L);
        return new WSVerificationExecutor(testCaseBinding, verificationScript, engine, eventManager, doCleanUp).execute(flowControl);
    }

    public static TestResult runTestCaseRawScript(String testScript, String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl) throws InterruptedException {
        Thread.sleep(50L);
        return new RawTestScriptExecutor(testScript, testCaseBinding, engine, eventManager, new InternalTestCaseContext(testCaseId)).execute(flowControl);
    }

    public static TestResult runFeatureFile(String featureFile) throws InterruptedException {
        Thread.sleep(50L);
        String verificationScript = MessageFormat.format("import com.kms.katalon.core.cucumber.keyword.CucumberBuiltinKeywords as CucumberKW\nCucumberKW.runFeatureFile(''{0}'')", featureFile);
        return new WSVerificationExecutor(null, verificationScript, engine, eventManager, true, true).execute(FailureHandling.STOP_ON_FAILURE);
    }

    public static TestResult runTestCaseRawScript(String testScript, String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        return new RawTestScriptExecutor(testScript, testCaseBinding, engine, eventManager, new InternalTestCaseContext(testCaseId, testCaseBinding.getIterationVariableName()), doCleanUp).execute(flowControl);
    }

    public static void startTestSuite(String testSuiteId, Map<String, String> suiteProperties, File testCaseBindingFile) {
        TestSuiteExecutor testSuiteExecutor = new TestSuiteExecutor(testSuiteId, engine, eventManager);
        testSuiteExecutor.execute(suiteProperties, testCaseBindingFile);
    }

    public static void startTestCaseBinding(String testCaseId, File testCaseBindingFile) {
        TestCaseBindingExecutor testCaseBindingExecutor = new TestCaseBindingExecutor(testCaseId, engine, eventManager);
        testCaseBindingExecutor.execute(testCaseBindingFile);
    }

    public static void runTestCaseBindingRawScript(String testScript, String testCaseId, File testCaseBindingFile, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        new RawTestBindingScriptExecutor(testScript, testCaseId, engine, eventManager, doCleanUp, flowControl).execute(testCaseBindingFile);
    }

    public static void invokeStartSuite(String testSuiteId) {
        InternalTestSuiteContext testSuiteContext = new InternalTestSuiteContext();
        testSuiteContext.setTestSuiteId(testSuiteId);
        eventManager.publicEvent(ExecutionListenerEvent.BEFORE_TEST_SUITE, new Object[]{testSuiteContext});
    }

    public static void invokeEndSuite(String testSuiteId) {
        InternalTestSuiteContext testSuiteContext = new InternalTestSuiteContext();
        testSuiteContext.setTestSuiteId(testSuiteId);
        eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_SUITE, new Object[]{testSuiteContext});
    }

    public static Map<String, Object> getProtectedGlobalVariables() {
        String encryptedOverridingProtectedGlobalVariables;
        String encryptedOverridingGlobalVariables;
        if (secureVariables != null) {
            return secureVariables;
        }
        secureVariables = new HashMap<String, Object>();
        String encryptedGlobalVariablesString = System.getenv().get("ProtectedGlobalVariables");
        if (StringUtils.isNotBlank((CharSequence)encryptedGlobalVariablesString)) {
            try {
                Map<String, Object> protectedGlobalVariables = TestCaseMain.convertStringToMap(encryptedGlobalVariablesString, true);
                for (Map.Entry<String, Object> entry : protectedGlobalVariables.entrySet()) {
                    secureVariables.put(entry.getKey(), entry.getValue());
                }
            }
            catch (IOException | GeneralSecurityException e) {
                TestCaseMain.logGlobalVariableError(e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(encryptedOverridingGlobalVariables = System.getenv().get("OverridingGlobalVariables")))) {
            try {
                Map<String, Object> overridingGlobalVariables = TestCaseMain.convertStringToMap(encryptedOverridingGlobalVariables, true);
                ArrayList<String> warningOverridingVariables = new ArrayList<String>();
                for (Map.Entry<String, Object> entry : overridingGlobalVariables.entrySet()) {
                    String variableName = entry.getKey();
                    if (!secureVariables.containsKey(variableName)) continue;
                    secureVariables.put(variableName, entry.getValue());
                    warningOverridingVariables.add(variableName);
                }
                if (warningOverridingVariables.size() > 0) {
                    logger.warn(MessageFormat.format("Using g_ for protected variables {0}, continuing as protected", String.join((CharSequence)", ", warningOverridingVariables)));
                }
            }
            catch (IOException | GeneralSecurityException e) {
                TestCaseMain.logGlobalVariableError(e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(encryptedOverridingProtectedGlobalVariables = System.getenv().get("OverridingProtectedGlobalVariables")))) {
            try {
                Map<String, Object> overridingProtectedGlobalVariables = TestCaseMain.convertStringToMap(encryptedOverridingProtectedGlobalVariables, true);
                ArrayList<String> warningOverridingVariables = new ArrayList<String>();
                for (Map.Entry<String, Object> entry : overridingProtectedGlobalVariables.entrySet()) {
                    String variableName = entry.getKey();
                    if (!secureVariables.containsKey(variableName)) {
                        warningOverridingVariables.add(variableName);
                    }
                    secureVariables.put(variableName, entry.getValue());
                }
                if (warningOverridingVariables.size() > 0) {
                    logger.warn(MessageFormat.format("Using p_ for unprotected variables {0}, continuing as protected", String.join((CharSequence)", ", warningOverridingVariables)));
                }
            }
            catch (IOException | GeneralSecurityException e) {
                TestCaseMain.logGlobalVariableError(e);
            }
        }
        return secureVariables;
    }

    public static Map<String, Object> getGlobalVariables(String profileName) {
        Map<String, Object> protectedGlobalVariables = TestCaseMain.getProtectedGlobalVariables();
        Map<Object, Object> overridingGlobalVariables = new HashMap();
        String encryptedOverridingGlobalVariables = System.getenv().get("OverridingGlobalVariables");
        if (StringUtils.isNotBlank((CharSequence)encryptedOverridingGlobalVariables)) {
            try {
                overridingGlobalVariables = TestCaseMain.convertStringToMap(encryptedOverridingGlobalVariables, true);
            }
            catch (Exception e) {
                TestCaseMain.logGlobalVariableError(e);
            }
        }
        try {
            HashMap<String, Object> selectedVariables = new HashMap<String, Object>();
            Node rootNode = new XmlParser().parse(new File(RunConfiguration.getProjectDir(), "Profiles/" + profileName + ".glbl"));
            NodeList variableNodes = (NodeList)rootNode.get("GlobalVariableEntity");
            int index = 0;
            while (index < variableNodes.size()) {
                Node globalVariableNode = (Node)variableNodes.get(index);
                String variableName = ((Node)((NodeList)globalVariableNode.get("name")).get(0)).text();
                Object defaultValue = ((Node)((NodeList)globalVariableNode.get("initValue")).get(0)).text();
                try {
                    defaultValue = engine.runScriptWithoutLogging((String)defaultValue, new Binding());
                    selectedVariables.put(variableName, defaultValue);
                }
                catch (Exception e) {
                    TestCaseMain.logGlobalVariableError(e);
                }
                Object value = null;
                if (protectedGlobalVariables.containsKey(variableName)) {
                    value = protectedGlobalVariables.get(variableName);
                } else if (overridingGlobalVariables.containsKey(variableName)) {
                    value = overridingGlobalVariables.get(variableName);
                }
                if (value != null) {
                    Object trimmed = String.valueOf(value).trim();
                    trimmed = defaultValue instanceof Integer ? ((String)trimmed).replaceAll("^'|'$", "") : (((String)trimmed).matches("^'.*'$") ? trimmed : "'" + (String)trimmed + "'");
                    try {
                        value = engine.runScriptWithoutLogging((String)trimmed, new Binding());
                        selectedVariables.put(variableName, value);
                    }
                    catch (Exception e) {
                        TestCaseMain.logGlobalVariableError(e);
                    }
                }
                ++index;
            }
            return selectedVariables;
        }
        catch (Exception ex) {
            TestCaseMain.logGlobalVariableError(ex);
            return Collections.emptyMap();
        }
    }

    public static void logGlobalVariableError(Exception e) {
        KatalonRuntimeException runtimeException = new KatalonRuntimeException(String.format("There was something wrong in GlobalVariable. Details: %s", e.getMessage()));
        ErrorCollector.getCollector().addError(runtimeException);
    }

    public static ScriptEngine getScriptEngine() {
        return engine;
    }

    private static Map<String, Object> convertStringToMap(String string, boolean encrypted) throws GeneralSecurityException, IOException {
        String mapString = string;
        if (encrypted) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)mapString);
            mapString = CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return (Map)new ObjectMapper().readValue(mapString, Map.class);
    }

    private static File findLogPropertyFile() {
        String configFolderPath = RunConfiguration.getProjectDir() + File.separator + "Include/config";
        File configFolder = new File(configFolderPath);
        if (!configFolder.exists()) {
            return null;
        }
        return FileUtils.listFiles((File)configFolder, (String[])new String[]{"properties"}, (boolean)true).stream().filter(f -> "log.properties".equals(f.getName())).findFirst().orElse(null);
    }
}

